/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentHelper {
    public static DocumentModel saveDocument(CoreSession session, DocumentModel doc) throws ClientException {
        doc = session.saveDocument(doc);
        return session.getDocument(doc.getRef());
    }

    public static void removeProperty(DocumentModel doc, String xpath) throws ClientException {
        Property p = doc.getProperty(xpath);
        if (p.isList()) {
            ((ListProperty)p).clear();
        } else {
            Property pp = p.getParent();
            if (pp != null && pp.isList()) {
                ((ListProperty)pp).remove(p);
            } else {
                p.remove();
            }
        }
    }

    public static void addBlob(Property p, Blob blob) throws PropertyException {
        if (p.isList()) {
            Type ft = ((ListProperty)p).getType().getFieldType();
            if (ft.isComplexType() && ((ComplexType)ft).getFieldsCount() == 2) {
                p.add(DocumentHelper.createBlobHolderMap(blob));
            } else {
                p.add((Object)blob);
            }
        } else {
            p.setValue((Object)blob);
        }
    }

    public static HashMap<String, Serializable> createBlobHolderMap(Blob blob) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("file", (Serializable)blob);
        map.put("filename", (Serializable)((Object)blob.getFilename()));
        return map;
    }

    public static void setProperties(CoreSession session, DocumentModel doc, Map<String, String> values) throws Exception {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            Property p;
            Type type;
            String key = entry.getKey();
            String value = entry.getValue();
            if ("ecm:acl".equals(key)) {
                DocumentHelper.setLocalAcl(session, doc, value);
            }
            if (!(type = (p = doc.getProperty(key)).getField().getType()).isSimpleType()) {
                throw new OperationException("Only scalar types can be set using update operation");
            }
            if (value == null || value.length() == 0) {
                p.setValue(null);
                continue;
            }
            p.setValue(((SimpleType)type).getPrimitiveType().decode(value));
        }
    }

    protected static void setLocalAcl(CoreSession session, DocumentModel doc, String value) throws ClientException {
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = new ACLImpl("local");
        acp.addACL((ACL)acl);
        String[] entries = StringUtils.split((String)value, (char)',', (boolean)true);
        if (entries.length == 0) {
            return;
        }
        for (int i = 0; i < entries.length; ++i) {
            String[] ace = StringUtils.split((String)entries[i], (char)':', (boolean)true);
            acl.add((Object)new ACE(ace[0], ace[1], Boolean.parseBoolean(ace[2])));
        }
        session.setACP(doc.getRef(), (ACP)acp, false);
    }
}

