/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.scripting;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Functions {
    public static final Functions INSTANCE = new Functions();
    protected volatile DirectoryService dirService = null;
    protected volatile UserManager userMgr;

    public UserManager getUserManager() throws Exception {
        if (this.userMgr == null) {
            this.userMgr = (UserManager)Framework.getService(UserManager.class);
        }
        return this.userMgr;
    }

    public DirectoryService getDirService() throws Exception {
        if (this.dirService == null) {
            this.dirService = (DirectoryService)Framework.getService(DirectoryService.class);
        }
        return this.dirService;
    }

    public String getVocabularyLabel(String voc, String key) throws Exception {
        Session session = this.getDirService().open(voc);
        DocumentModel doc = session.getEntry(key);
        DataModel dm = (DataModel)doc.getDataModels().values().iterator().next();
        return (String)dm.getData("label");
    }

    public NuxeoPrincipal getPrincipal(String username) throws Exception {
        return this.getUserManager().getPrincipal(username);
    }

    protected String getEmail(NuxeoPrincipal principal, String userSchemaName, String userEmailFieldName) throws ClientException {
        if (principal == null) {
            return null;
        }
        return (String)principal.getModel().getProperty(userSchemaName, userEmailFieldName);
    }

    public String getEmail(String username) throws Exception {
        UserManager userManager = this.getUserManager();
        return this.getEmail(userManager.getPrincipal(username), userManager.getUserSchemaName(), userManager.getUserEmailField());
    }

    public StringList getPrincipalEmails(List<NuxeoPrincipal> principals) throws Exception {
        StringList result = new StringList(principals.size());
        String schemaName = this.userMgr.getUserSchemaName();
        String fieldName = this.userMgr.getUserEmailField();
        for (NuxeoPrincipal principal : principals) {
            String email = this.getEmail(principal, schemaName, fieldName);
            if (StringUtils.isEmpty((String)email)) continue;
            result.add(email);
        }
        return result;
    }

    public StringList getEmails(List<String> usernames) throws Exception {
        UserManager userManager = this.getUserManager();
        StringList result = new StringList(usernames.size());
        String schemaName = this.userMgr.getUserSchemaName();
        String fieldName = this.userMgr.getUserEmailField();
        for (String username : usernames) {
            String email;
            NuxeoPrincipal principal = userManager.getPrincipal(username);
            if (principal == null || StringUtils.isEmpty((String)(email = this.getEmail(principal, schemaName, fieldName)))) continue;
            result.add(email);
        }
        return result;
    }
}

