/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Document.SetLifeCycle", category="Document", label="Follow Life Cycle Transition", description="Follow the given transition on the input document life cycle state")
public class SetDocumentLifeCycle {
    public static final String ID = "Document.SetLifeCycle";
    @Context
    protected CoreSession session;
    @Param(name="value")
    protected String value;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        doc.followTransition(this.value);
        return doc;
    }

    @OperationMethod
    public DocumentRef run(DocumentRef doc) throws Exception {
        this.session.followTransition(doc, this.value);
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentModel doc : docs) {
            result.add((Object)this.run(doc));
        }
        return result;
    }

    @OperationMethod
    public DocumentModelList run(DocumentRefList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentRef doc : docs) {
            result.add((Object)this.session.getDocument(this.run(doc)));
        }
        return result;
    }
}

