/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Document.Lock", category="Document", label="Lock", description="Lock the input document in the name of the given 'owner'. The lock owner is an username and identify the user that owns the lock on the document. If the owner is not specified the current user will be used as the owner. Return back the locked document")
public class LockDocument {
    public static final String ID = "Document.Lock";
    @Context
    protected CoreSession session;
    @Param(name="owner", required=false)
    protected String value;

    @OperationMethod
    public DocumentRef run(DocumentRef doc) throws Exception {
        if (this.value == null) {
            this.value = this.session.getPrincipal().getName();
        }
        this.session.setLock(doc, this.value);
        return doc;
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        if (this.value == null) {
            this.value = this.session.getPrincipal().getName();
        }
        doc.setLock(this.value);
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentModel doc : docs) {
            result.add((Object)this.run(doc));
        }
        return result;
    }

    @OperationMethod
    public DocumentModelList run(DocumentRefList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentRef doc : docs) {
            result.add((Object)this.session.getDocument(this.run(doc)));
        }
        return result;
    }
}

