/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.io.Serializable;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;

@Operation(id="Document.CreateVersion", category="Document", label="Snapshot Version", description="Create a new version for the input document. Any modification made on the document by the chain will be automatically saved. Increment version if this was specified through the 'snapshot' parameter. Returns the live document (not the version).")
public class CreateVersion {
    public static final String ID = "Document.CreateVersion";
    @Context
    protected CoreSession session;
    @Param(name="increment", required=false, widget="Option", values={"None", "Minor", "Major"})
    protected String snapshot = "None";

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        VersioningActions va = null;
        if ("Minor".equals(this.snapshot)) {
            va = VersioningActions.ACTION_INCREMENT_MINOR;
        } else if ("Major".equals(this.snapshot)) {
            va = VersioningActions.ACTION_INCREMENT_MAJOR;
        }
        if (va != null) {
            ScopedMap ctxData = doc.getContextData();
            ctxData.putScopedValue(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.valueOf(true));
            ctxData.putScopedValue(ScopeType.REQUEST, "VersioningOption", (Serializable)va);
        } else {
            ScopedMap ctxData = doc.getContextData();
            ctxData.putScopedValue(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.valueOf(false));
        }
        return DocumentHelper.saveDocument(this.session, doc);
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentModel doc : docs) {
            result.add((Object)this.run(doc));
        }
        return result;
    }
}

