/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Document.Copy", label="Copy", category="Document", description="Copy the input document into the given folder. The name parameter will be used as the copy name otherwise if not specified the original name will be preserved. The target folder can be specified as an absolute or relative path (relative to the input document) as an UID or by using an EL expression. Return the newly created document (the copy).")
public class CopyDocument {
    public static final String ID = "Document.Copy";
    @Context
    protected CoreSession session;
    @Param(name="target")
    protected DocumentRef target;
    @Param(name="name", required=false)
    protected String name;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        String n = this.name;
        if (this.name == null || this.name.length() == 0) {
            n = doc.getName();
        }
        return this.session.copy(doc.getRef(), this.target, n);
    }

    @OperationMethod
    public DocumentModel run(DocumentRef ref) throws Exception {
        String n = this.name;
        if (this.name == null || this.name.length() == 0) {
            n = this.session.getDocument(ref).getName();
        }
        return this.session.copy(ref, this.target, n);
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentModel doc : docs) {
            result.add((Object)this.run(doc));
        }
        return result;
    }

    @OperationMethod
    public DocumentModelList run(DocumentRefList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentRef doc : docs) {
            result.add((Object)this.run(doc));
        }
        return result;
    }
}

