/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.zip.ZipOutputStream;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.FileCleanupHandler;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;

@Operation(id="Blob.CreateZip", category="Files", label="Zip", description="Create a zip file from the input file(s). If no file name is given the first file name in the input will be used. Returns the zip file.")
public class CreateZip {
    public static final String ID = "Blob.CreateZip";
    @Context
    protected OperationContext ctx;
    @Param(name="filename", required=false)
    protected String fileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Blob run(Blob blob) throws Exception {
        if (this.fileName == null || (this.fileName = this.fileName.trim()).length() == 0) {
            this.fileName = blob.getFilename();
        }
        File file = File.createTempFile("nxops-createzip-", ".tmp");
        this.ctx.addCleanupHandler(new FileCleanupHandler(file));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
        try {
            this.zip(blob, out);
        }
        finally {
            out.finish();
            out.close();
        }
        return new FileBlob(file, "application/zip", null, this.fileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Blob run(BlobList blobs) throws Exception {
        if (this.fileName == null || (this.fileName = this.fileName.trim()).length() == 0) {
            this.fileName = blobs.isEmpty() ? null : ((Blob)blobs.get(0)).getFilename();
        }
        File file = File.createTempFile("nxops-createzip-", ".tmp");
        this.ctx.addCleanupHandler(new FileCleanupHandler(file));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
        try {
            this.zip(blobs, out);
        }
        finally {
            out.finish();
            out.close();
        }
        return new FileBlob(file, "application/zip", null, this.fileName, null);
    }

    protected String getFileName(Blob blob) {
        String entry = blob.getFilename();
        if (entry == null) {
            entry = "Unknown_" + System.identityHashCode(blob);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zip(Blob blob, ZipOutputStream out) throws Exception {
        String entry = this.getFileName(blob);
        InputStream in = blob.getStream();
        try {
            ZipUtils._zip((String)entry, (InputStream)in, (ZipOutputStream)out);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zip(BlobList blobs, ZipOutputStream out) throws Exception {
        HashSet<String> names = new HashSet<String>();
        int cnt = 1;
        for (Blob blob : blobs) {
            String entry = this.getFileName(blob);
            if (!names.add(entry)) {
                entry = "renamed_" + cnt++ + "_" + entry;
            }
            InputStream in = blob.getStream();
            try {
                ZipUtils._zip((String)entry, (InputStream)in, (ZipOutputStream)out);
            }
            finally {
                in.close();
            }
        }
    }
}

