/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Blob.Attach", category="Files", label="Attach File", description="Attach the input file to the document given as a parameter. If the xpath points to a blob list then the blob is appended to the list, otherwise the xpath should point to a blob property. If the save parameter is set the document modification will be automatically saved. Return the blob.")
public class AttachBlob {
    public static final String ID = "Blob.Attach";
    @Context
    protected CoreSession session;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";
    @Param(name="document")
    protected DocumentModel doc;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod
    public Blob run(Blob blob) throws Exception {
        DocumentHelper.addBlob(this.doc.getProperty(this.xpath), blob);
        if (this.save) {
            this.doc = this.session.saveDocument(this.doc);
        }
        return blob;
    }
}

