/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Context.RestoreDocumentInput", category="Context", label="Restore Document Input", description="Restore the document input from a context variable given its name. Return the document.")
public class RestoreDocumentInput {
    public static final String ID = "Context.RestoreDocumentInput";
    @Context
    protected OperationContext ctx;
    @Param(name="name")
    protected String name;

    @OperationMethod
    public DocumentModel run() throws Exception {
        Object obj = this.ctx.get(this.name);
        if (obj instanceof DocumentModel) {
            return (DocumentModel)obj;
        }
        if (obj instanceof DocumentRef) {
            return this.ctx.getCoreSession().getDocument((DocumentRef)obj);
        }
        throw new OperationException("Illegal state error for restore document operation. The context map doesn't contains a document variable with name " + this.name);
    }
}

