/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.CompiledChain;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.impl.AdapterKeyedRegistry;
import org.nuxeo.ecm.automation.core.impl.CompiledChainImpl;
import org.nuxeo.ecm.automation.core.impl.OperationTypeImpl;
import org.nuxeo.ecm.automation.core.impl.TypeAdapterKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationServiceImpl
implements AutomationService {
    protected final Map<String, OperationTypeImpl> operations = new HashMap<String, OperationTypeImpl>();
    protected volatile Map<String, OperationTypeImpl> lookup;
    protected final Map<String, ChainEntry> chains = new HashMap<String, ChainEntry>();
    protected volatile Map<String, ChainEntry> chainLookup;
    protected AdapterKeyedRegistry adapters = new AdapterKeyedRegistry();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run(OperationContext ctx, String chainId) throws Exception, InvalidChainException {
        try {
            Object input = ctx.getInput();
            Class<Void> inputType = input == null ? Void.TYPE : input.getClass();
            ChainEntry chain = this.getChainEntry(chainId);
            if (chain.cchain == null) {
                chain.cchain = this.compileChain(inputType, chain.chain);
            }
            Object ret = chain.cchain.invoke(ctx);
            if (ctx.getCoreSession() != null && ctx.isCommit()) {
                ctx.getCoreSession().save();
            }
            Object object = ret;
            return object;
        }
        finally {
            ctx.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run(OperationContext ctx, OperationChain chain) throws Exception, InvalidChainException {
        try {
            Object input = ctx.getInput();
            Class<Void> inputType = input == null ? Void.TYPE : input.getClass();
            Object ret = this.compileChain(inputType, chain).invoke(ctx);
            if (ctx.getCoreSession() != null && ctx.isCommit()) {
                ctx.getCoreSession().save();
            }
            Object object = ret;
            return object;
        }
        finally {
            ctx.dispose();
        }
    }

    @Override
    public synchronized void putOperationChain(OperationChain chain) throws OperationException {
        this.putOperationChain(chain, false);
    }

    @Override
    public synchronized void putOperationChain(OperationChain chain, boolean replace) throws OperationException {
        if (!replace && this.chains.containsKey(chain.getId())) {
            throw new OperationException("Chain with id " + chain.getId() + " already exists");
        }
        this.chains.put(chain.getId(), new ChainEntry(chain));
        this.chainLookup = null;
    }

    @Override
    public synchronized void removeOperationChain(String id) {
        if (this.chains.remove(id) != null) {
            this.chainLookup = null;
        }
    }

    @Override
    public OperationChain getOperationChain(String id) throws OperationNotFoundException {
        ChainEntry chain = this.chainLookup().get(id);
        if (chain == null) {
            throw new OperationNotFoundException("No such chain was registered: " + id);
        }
        return chain.chain;
    }

    @Override
    public List<OperationChain> getOperationChains() {
        ArrayList<OperationChain> result = new ArrayList<OperationChain>();
        Map<String, ChainEntry> chains = this.chainLookup();
        for (ChainEntry entry : chains.values()) {
            result.add(entry.chain);
        }
        return result;
    }

    public ChainEntry getChainEntry(String id) throws OperationException {
        ChainEntry chain = this.chainLookup().get(id);
        if (chain == null) {
            throw new OperationException("No such chain was registered: " + id);
        }
        return chain;
    }

    @Override
    public void putOperation(Class<?> type) throws OperationException {
        OperationTypeImpl op = new OperationTypeImpl(this, type);
        this.putOperation(op, false);
    }

    @Override
    public void putOperation(Class<?> type, boolean replace) throws OperationException {
        OperationTypeImpl op = new OperationTypeImpl(this, type);
        this.putOperation(op, replace);
    }

    protected synchronized void putOperation(OperationTypeImpl op, boolean replace) throws OperationException {
        if (!replace && this.operations.containsKey(op.getId())) {
            throw new OperationException("An operation is already bound to: " + op.getId() + ". Use 'replace=true' to replace an existing operation");
        }
        this.operations.put(op.getId(), op);
        this.lookup = null;
    }

    @Override
    public synchronized void removeOperation(Class<?> key) {
        OperationType op = this.operations.remove(key.getAnnotation(Operation.class).id());
        if (op != null) {
            this.operations.remove(op.getId());
            this.lookup = null;
        }
    }

    @Override
    public OperationType[] getOperations() {
        Collection<OperationTypeImpl> values = this.lookup().values();
        return values.toArray(new OperationType[values.size()]);
    }

    @Override
    public OperationType getOperation(String id) throws OperationNotFoundException {
        OperationType op = this.lookup().get(id);
        if (op == null) {
            throw new OperationNotFoundException("No operation was bound on ID: " + id);
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, OperationTypeImpl> lookup() {
        Map<String, OperationTypeImpl> _lookup = this.lookup;
        if (_lookup == null) {
            OperationServiceImpl operationServiceImpl = this;
            synchronized (operationServiceImpl) {
                _lookup = this.lookup = new HashMap<String, OperationTypeImpl>(this.operations);
            }
        }
        return _lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, ChainEntry> chainLookup() {
        Map<String, ChainEntry> _lookup = this.chainLookup;
        if (_lookup == null) {
            OperationServiceImpl operationServiceImpl = this;
            synchronized (operationServiceImpl) {
                _lookup = this.chainLookup = new HashMap<String, ChainEntry>(this.chains);
            }
        }
        return _lookup;
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationChain chain) throws Exception, InvalidChainException {
        List<OperationParameters> ops = chain.getOperations();
        return this.compileChain(inputType, ops.toArray(new OperationParameters[ops.size()]));
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationParameters ... chain) throws Exception, InvalidChainException {
        return CompiledChainImpl.buildChain(this, inputType == null ? Void.TYPE : inputType, chain);
    }

    @Override
    public void putTypeAdapter(Class<?> accept, Class<?> produce, TypeAdapter adapter) {
        this.adapters.put(new TypeAdapterKey(accept, produce), adapter);
    }

    @Override
    public void removeTypeAdapter(Class<?> accept, Class<?> produce) {
        this.adapters.remove(new TypeAdapterKey(accept, produce));
    }

    @Override
    public TypeAdapter getTypeAdapter(Class<?> accept, Class<?> produce) {
        return (TypeAdapter)this.adapters.get(new TypeAdapterKey(accept, produce));
    }

    @Override
    public boolean isTypeAdaptable(Class<?> typeToAdapt, Class<?> targetType) {
        return this.getTypeAdapter(typeToAdapt, targetType) != null;
    }

    @Override
    public <T> T getAdaptedValue(OperationContext ctx, Object toAdapt, Class<?> targetType) throws Exception {
        if (toAdapt == null) {
            return null;
        }
        Class<?> toAdaptClass = toAdapt.getClass();
        if (targetType.isPrimitive() && (targetType = OperationServiceImpl.getTypeForPrimitive(targetType)).isAssignableFrom(toAdaptClass)) {
            return (T)toAdapt;
        }
        TypeAdapter adapter = this.getTypeAdapter(toAdaptClass, targetType);
        if (adapter == null) {
            throw new OperationException("No type adapter found for input: " + toAdapt.getClass() + " and output " + targetType);
        }
        return (T)adapter.getAdaptedValue(ctx, toAdapt);
    }

    @Override
    public List<OperationDocumentation> getDocumentation() {
        ArrayList<OperationDocumentation> result = new ArrayList<OperationDocumentation>();
        Collection<OperationTypeImpl> ops = this.lookup().values();
        for (OperationTypeImpl ot : ops.toArray(new OperationTypeImpl[ops.size()])) {
            result.add(ot.getDocumentation());
        }
        Collections.sort(result);
        return result;
    }

    public static Class<?> getTypeForPrimitive(Class<?> primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        return primitiveType;
    }

    static class ChainEntry {
        OperationChain chain;
        CompiledChain cchain;

        ChainEntry(OperationChain chain) {
            this.chain = chain;
        }
    }
}

