/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.lang.reflect.Method;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokableMethod {
    public static final int VOID_PRIORITY = 1;
    public static final int ADAPTABLE_PRIORITY = 2;
    public static final int ISTANCE_OF_PRIORITY = 3;
    public static final int EXACT_MATCH_PRIORITY = 4;
    public static final int USER_PRIORITY = 9;
    protected OperationType op;
    protected Method method;
    protected Class<?> produce;
    protected Class<?> consume;
    protected int priority;

    public InvokableMethod(OperationType op, Method method) {
        this.produce = method.getReturnType();
        Class<?>[] p = method.getParameterTypes();
        if (p.length > 1) {
            throw new IllegalArgumentException("Operation method must accept at most one argument: " + method);
        }
        this.op = op;
        this.method = method;
        this.priority = method.getAnnotation(OperationMethod.class).priority();
        if (this.priority > 0) {
            this.priority += 9;
        }
        this.consume = p.length == 0 ? Void.TYPE : p[0];
    }

    public int getPriority() {
        return this.priority;
    }

    public OperationType getOperation() {
        return this.op;
    }

    public final Class<?> getOutputType() {
        return this.produce;
    }

    public final Class<?> getInputType() {
        return this.consume;
    }

    public int inputMatch(Class<?> in) {
        if (this.consume == in) {
            return this.priority > 0 ? this.priority : 4;
        }
        if (this.consume.isAssignableFrom(in)) {
            return this.priority > 0 ? this.priority : 3;
        }
        if (this.op.getService().isTypeAdaptable(in, this.consume)) {
            return this.priority > 0 ? this.priority : 2;
        }
        if (this.consume == Void.TYPE) {
            return this.priority > 0 ? this.priority : 1;
        }
        return 0;
    }

    public int outputMatch(Class<?> out) {
        if (this.produce == out) {
            return this.priority > 0 ? this.priority : 4;
        }
        if (out.isAssignableFrom(this.produce)) {
            return this.priority > 0 ? this.priority : 3;
        }
        if (this.op.getService().isTypeAdaptable(this.produce, out)) {
            return this.priority > 0 ? this.priority : 2;
        }
        return 0;
    }

    public Object invoke(OperationContext ctx, Map<String, Object> args) throws Exception {
        try {
            Object input = ctx.getInput();
            Object target = this.op.newInstance(ctx, args);
            if (this.consume == Void.TYPE) {
                Object out = this.method.invoke(target, new Object[0]);
                return this.produce == Void.TYPE ? input : out;
            }
            if (input != null && !this.consume.isAssignableFrom(input.getClass())) {
                input = this.op.getService().getAdaptedValue(ctx, input, this.consume);
            }
            return this.method.invoke(target, input);
        }
        catch (Exception e) {
            throw new OperationException("Failed to invoke operation " + this.getOperation().getId(), e);
        }
    }
}

