/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.CompiledChain;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.impl.OperationTypeImpl;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompiledChainImpl
implements CompiledChain {
    protected AutomationService service;
    protected final OperationTypeImpl op;
    protected final Map<String, Object> args;
    protected InvokableMethod method;
    protected CompiledChainImpl next;

    public CompiledChainImpl(OperationTypeImpl op, Map<String, Object> args) {
        this(null, op, args);
    }

    public CompiledChainImpl(CompiledChainImpl parent, OperationTypeImpl op, Map<String, Object> args) {
        if (parent != null) {
            parent.next = this;
        }
        this.op = op;
        this.args = args;
    }

    public final InvokableMethod method() {
        return this.method;
    }

    public final Map<String, Object> args() {
        return this.args;
    }

    public boolean initializePath(Class<?> in) {
        InvokableMethod[] methods = this.op.getMethodsMatchingInput(in);
        if (methods == null) {
            return false;
        }
        if (this.next == null) {
            this.method = methods[0];
            return true;
        }
        for (InvokableMethod m : methods) {
            Class<?> nextIn = m.getOutputType();
            if (nextIn == Void.TYPE) {
                nextIn = in;
            }
            if (!this.next.initializePath(nextIn)) continue;
            this.method = m;
            return true;
        }
        return false;
    }

    @Override
    public Object invoke(OperationContext ctx) throws Exception {
        Object out = this.method.invoke(ctx, this.args);
        ctx.setInput(out);
        if (this.next != null) {
            return this.next.invoke(ctx);
        }
        return out;
    }

    public static CompiledChainImpl buildChain(Class<?> in, OperationParameters[] params) throws Exception {
        return CompiledChainImpl.buildChain((AutomationService)Framework.getLocalService(AutomationService.class), in, params);
    }

    public static CompiledChainImpl buildChain(AutomationService service, Class<?> in, OperationParameters[] chainParams) throws Exception {
        CompiledChainImpl invocation;
        if (chainParams.length == 0) {
            throw new InvalidChainException("Null operation chain.");
        }
        OperationParameters params = chainParams[0];
        CompiledChainImpl last = invocation = new CompiledChainImpl((OperationTypeImpl)service.getOperation(params.id()), params.map());
        for (int i = 1; i < chainParams.length; ++i) {
            params = chainParams[i];
            last = new CompiledChainImpl(last, (OperationTypeImpl)service.getOperation(params.id()), params.map());
        }
        if (!invocation.initializePath(in)) {
            throw new InvalidChainException("Cannot find any valid path in operation chain");
        }
        return invocation;
    }
}

