/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions.ejb;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Local(value={ActionManager.class})
@Remote(value={ActionManager.class})
public class ActionManagerBean
implements ActionManager {
    private static final long serialVersionUID = 8398790411119200730L;
    private static final Log log = LogFactory.getLog(ActionManagerBean.class);
    private ActionManager actionService;

    @PostConstruct
    public void initialize() {
        try {
            this.actionService = (ActionManager)Framework.getLocalService(ActionManager.class);
        }
        catch (Exception e) {
            log.error((Object)"Failed to lookup ActionService", (Throwable)e);
        }
    }

    @Override
    public List<Action> getActions(String category, ActionContext ctx) {
        return this.getActions(category, ctx, true);
    }

    @Override
    public List<Action> getActions(String category, ActionContext ctx, boolean hideUnavailableActions) {
        return this.actionService.getActions(category, ctx, hideUnavailableActions);
    }

    @Override
    public boolean isEnabled(String actionId, ActionContext context) {
        return this.actionService.isEnabled(actionId, context);
    }

    @Override
    public boolean isRegistered(String actionId) {
        return this.actionService.isRegistered(actionId);
    }

    @Override
    public Action getAction(String actionId) {
        return this.actionService.getAction(actionId);
    }

    @Override
    public ActionFilter[] getFilters(String actionId) {
        return this.actionService.getFilters(actionId);
    }

    @Override
    @Remove
    public void remove() {
        this.actionService = null;
    }

    @PostActivate
    public void readState() {
        log.info((Object)"PostActivate");
        this.initialize();
    }

    @PrePassivate
    public void saveState() {
        log.info((Object)"PrePassivate");
        this.remove();
    }

    @Override
    public List<Action> getAllActions(String category) {
        return this.actionService.getAllActions(category);
    }
}

