/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.service;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.mimetype.MimetypeEntryImpl;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="mimetype")
public class MimetypeDescriptor {
    @XNode(value="@normalized")
    protected String normalized;
    @XNode(value="@binary")
    protected boolean binary = true;
    @XNode(value="@onlineEditable")
    protected boolean onlineEditable = false;
    @XNode(value="@oleSupported")
    protected boolean oleSupported = false;
    @XNode(value="@iconPath")
    protected String iconPath;
    @XNode(value="mimetypes")
    protected Element mimetypes;
    @XNode(value="extensions")
    protected Element extensions;

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public boolean isOnlineEditable() {
        return this.onlineEditable;
    }

    public void setOnlineEditable(boolean onlineEditable) {
        this.onlineEditable = onlineEditable;
    }

    public boolean isOleSupported() {
        return this.oleSupported;
    }

    public void setOleSupported(boolean oleSupported) {
        this.oleSupported = oleSupported;
    }

    public List<String> getExtensions() {
        ArrayList<String> exts = new ArrayList<String>();
        NodeList elements = this.mimetypes.getElementsByTagName("extension");
        int len = elements.getLength();
        for (int i = 0; i < len; ++i) {
            exts.add(elements.item(i).getTextContent().trim());
        }
        return exts;
    }

    public void setExtensions(Element extensions) {
        this.extensions = extensions;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public List<String> getMimetypes() {
        ArrayList<String> mtypes = new ArrayList<String>();
        NodeList elements = this.mimetypes.getElementsByTagName("mimetype");
        int len = elements.getLength();
        for (int i = 0; i < len; ++i) {
            mtypes.add(elements.item(i).getTextContent().trim());
        }
        return mtypes;
    }

    public void setMimetypes(Element mimetypes) {
        this.mimetypes = mimetypes;
    }

    public MimetypeEntry getMimetype() {
        return new MimetypeEntryImpl(this.normalized, this.getMimetypes(), this.getExtensions(), this.iconPath, this.binary, this.onlineEditable, this.oleSupported);
    }

    public String getNormalized() {
        return this.normalized;
    }

    public void setNormalized(String normalized) {
        this.normalized = normalized;
    }
}

