/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.test;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.iri.Violation;
import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.IRIExamples;
import com.hp.hpl.jena.iri.impl.Specification;
import com.hp.hpl.jena.iri.impl.ViolationCodeInfo;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestErrorMessages
extends TestCase
implements ViolationCodes {
    static Specification[] specs;
    String uri;
    ViolationCodeInfo violation;
    boolean good;
    public static IRIFactory f;

    public TestErrorMessages(String uri, ViolationCodeInfo info, boolean good) {
        super(TestErrorMessages.escapeAndShorten(uri));
        this.uri = uri;
        this.violation = info;
        this.good = good;
    }

    private static String escapeAndShorten(String uri2) {
        StringBuffer rslt = new StringBuffer();
        int ln = uri2.length();
        if (ln > 80) {
            ln = 80;
        }
        for (int i = 0; i < ln; ++i) {
            char ch = uri2.charAt(i);
            if (ch > '\u007f' || ch < ' ') {
                rslt.append("&#");
                rslt.append((int)ch);
                rslt.append(";");
                continue;
            }
            rslt.append(ch);
        }
        return rslt.toString();
    }

    private void printErrorMessages(Violation v) {
        System.err.println(v.getShortMessage());
    }

    public void runTest() {
        IRI iri = f.create(this.uri);
        Iterator it = iri.violations(true);
        while (it.hasNext()) {
            Violation v = (Violation)it.next();
            this.printErrorMessages(v);
        }
    }

    public static TestSuite suite() {
        TestSuite rslt = new TestSuite();
        rslt.setName("Error messages");
        TestErrorMessages.addAllTestsFromExamples(rslt);
        return rslt;
    }

    private static void addAllTestsFromExamples(TestSuite spec) {
        int i;
        for (i = 0; i < ViolationCodeInfo.all.length; ++i) {
            TestErrorMessages.addTestsFromExamples(spec, ViolationCodeInfo.all[i]);
        }
        for (i = 0; i < specs.length; ++i) {
            TestErrorMessages.addExamples(null, specs[i], spec);
        }
    }

    private static void addTestsFromExamples(TestSuite rslt, ViolationCodeInfo violationCodeInfo) {
        if (violationCodeInfo != null) {
            TestSuite ex = new TestSuite();
            ex.setName(violationCodeInfo.getCodeName());
            TestErrorMessages.addExamples(violationCodeInfo, violationCodeInfo, ex);
            if (ex.countTestCases() > 0) {
                rslt.addTest((Test)ex);
            }
        }
    }

    private static void addExamples(ViolationCodeInfo violationCodeInfo, IRIExamples examples, TestSuite ex) {
        int j;
        String[] e = examples.getBadExamples();
        for (j = 0; j < e.length; ++j) {
            ex.addTest((Test)new TestErrorMessages(e[j], violationCodeInfo, false));
        }
        e = examples.getGoodExamples();
        for (j = 0; j < e.length; ++j) {
            ex.addTest((Test)new TestErrorMessages(e[j], violationCodeInfo, true));
        }
    }

    static {
        new ViolationCodes.Initialize();
        specs = Specification.all.values().toArray(new Specification[0]);
        f = IRIFactory.jenaImplementation();
    }
}

