/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptorComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerList {
    protected final List<EventListenerDescriptor> inlineListenersDescriptors = new ArrayList<EventListenerDescriptor>();
    protected final List<EventListenerDescriptor> syncPostCommitListenersDescriptors = new ArrayList<EventListenerDescriptor>();
    protected final List<EventListenerDescriptor> asyncPostCommitListenersDescriptors = new ArrayList<EventListenerDescriptor>();
    protected final List<EventListenerDescriptor> enabledInlineListenersDescriptors = new ArrayList<EventListenerDescriptor>();
    protected final List<EventListenerDescriptor> enabledSyncPostCommitListenersDescriptors = new ArrayList<EventListenerDescriptor>();
    protected final List<EventListenerDescriptor> enabledAsyncPostCommitListenersDescriptors = new ArrayList<EventListenerDescriptor>();
    protected final List<String> listenerNames = new ArrayList<String>();
    protected boolean enabledFilteringDone = false;

    public void add(EventListenerDescriptor descriptor) throws Exception {
        this.enabledFilteringDone = false;
        if (this.listenerNames.contains(descriptor.getName())) {
            descriptor = this.mergeDescriptor(descriptor);
        }
        descriptor.initListener();
        if (descriptor.isPostCommit) {
            if (descriptor.isAsync.booleanValue()) {
                this.asyncPostCommitListenersDescriptors.add(descriptor);
                Collections.sort(this.asyncPostCommitListenersDescriptors, new EventListenerDescriptorComparator());
            } else {
                this.syncPostCommitListenersDescriptors.add(descriptor);
                Collections.sort(this.syncPostCommitListenersDescriptors, new EventListenerDescriptorComparator());
            }
        } else {
            this.inlineListenersDescriptors.add(descriptor);
            Collections.sort(this.inlineListenersDescriptors, new EventListenerDescriptorComparator());
        }
        this.listenerNames.add(descriptor.getName());
    }

    protected EventListenerDescriptor mergeDescriptor(EventListenerDescriptor descriptor) {
        EventListenerDescriptor existingDesc = this.getDescriptor(descriptor.getName());
        this.removeDescriptor(existingDesc);
        existingDesc.merge(descriptor);
        return existingDesc;
    }

    public void removeDescriptor(EventListenerDescriptor descriptor) {
        this.enabledFilteringDone = false;
        if (this.listenerNames.contains(descriptor.getName())) {
            if (descriptor.isPostCommit) {
                if (descriptor.isAsync.booleanValue()) {
                    this.asyncPostCommitListenersDescriptors.remove(descriptor);
                } else {
                    this.syncPostCommitListenersDescriptors.remove(descriptor);
                }
            } else {
                this.inlineListenersDescriptors.remove(descriptor);
            }
            this.listenerNames.remove(descriptor.getName());
        }
    }

    public EventListenerDescriptor getDescriptor(String listenerName) {
        if (!this.listenerNames.contains(listenerName)) {
            return null;
        }
        for (EventListenerDescriptor desc : this.inlineListenersDescriptors) {
            if (!desc.getName().equals(listenerName)) continue;
            return desc;
        }
        for (EventListenerDescriptor desc : this.syncPostCommitListenersDescriptors) {
            if (!desc.getName().equals(listenerName)) continue;
            return desc;
        }
        for (EventListenerDescriptor desc : this.asyncPostCommitListenersDescriptors) {
            if (!desc.getName().equals(listenerName)) continue;
            return desc;
        }
        return null;
    }

    public List<EventListener> getInLineListeners() {
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        for (EventListenerDescriptor desc : this.getEnabledInlineListenersDescriptors()) {
            listeners.add(desc.asEventListener());
        }
        return listeners;
    }

    public List<PostCommitEventListener> getSyncPostCommitListeners() {
        ArrayList<PostCommitEventListener> listeners = new ArrayList<PostCommitEventListener>();
        for (EventListenerDescriptor desc : this.getEnabledSyncPostCommitListenersDescriptors()) {
            listeners.add(desc.asPostCommitListener());
        }
        return listeners;
    }

    public List<PostCommitEventListener> getAsyncPostCommitListeners() {
        ArrayList<PostCommitEventListener> listeners = new ArrayList<PostCommitEventListener>();
        for (EventListenerDescriptor desc : this.getEnabledAsyncPostCommitListenersDescriptors()) {
            listeners.add(desc.asPostCommitListener());
        }
        return listeners;
    }

    public List<EventListenerDescriptor> getInlineListenersDescriptors() {
        return this.inlineListenersDescriptors;
    }

    public List<EventListenerDescriptor> getSyncPostCommitListenersDescriptors() {
        return this.syncPostCommitListenersDescriptors;
    }

    public List<EventListenerDescriptor> getAsyncPostCommitListenersDescriptors() {
        return this.asyncPostCommitListenersDescriptors;
    }

    public synchronized void recomputeEnabledListeners() {
        this.enabledAsyncPostCommitListenersDescriptors.clear();
        for (EventListenerDescriptor desc : this.asyncPostCommitListenersDescriptors) {
            if (!desc.isEnabled) continue;
            this.enabledAsyncPostCommitListenersDescriptors.add(desc);
        }
        this.enabledSyncPostCommitListenersDescriptors.clear();
        for (EventListenerDescriptor desc : this.syncPostCommitListenersDescriptors) {
            if (!desc.isEnabled) continue;
            this.enabledSyncPostCommitListenersDescriptors.add(desc);
        }
        this.enabledInlineListenersDescriptors.clear();
        for (EventListenerDescriptor desc : this.inlineListenersDescriptors) {
            if (!desc.isEnabled) continue;
            this.enabledInlineListenersDescriptors.add(desc);
        }
        this.enabledFilteringDone = true;
    }

    public synchronized List<EventListenerDescriptor> getEnabledInlineListenersDescriptors() {
        if (!this.enabledFilteringDone) {
            this.recomputeEnabledListeners();
        }
        return new ArrayList<EventListenerDescriptor>(this.enabledInlineListenersDescriptors);
    }

    public synchronized List<EventListenerDescriptor> getEnabledSyncPostCommitListenersDescriptors() {
        if (!this.enabledFilteringDone) {
            this.recomputeEnabledListeners();
        }
        return new ArrayList<EventListenerDescriptor>(this.enabledSyncPostCommitListenersDescriptors);
    }

    public synchronized List<EventListenerDescriptor> getEnabledAsyncPostCommitListenersDescriptors() {
        if (!this.enabledFilteringDone) {
            this.recomputeEnabledListeners();
        }
        return new ArrayList<EventListenerDescriptor>(this.enabledAsyncPostCommitListenersDescriptors);
    }

    public List<String> getListenerNames() {
        return this.listenerNames;
    }
}

