/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.types.FieldWidget;
import org.nuxeo.ecm.platform.types.Layouts;
import org.nuxeo.ecm.platform.types.SubType;
import org.nuxeo.ecm.platform.types.TypeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="type")
public class Type
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Type.class);
    public static final String[] EMPTY_ACTIONS = new String[0];
    @XNode(value="@id")
    protected String id;
    @XNode(value="icon")
    protected String icon;
    @XNode(value="icon-expanded")
    protected String iconExpanded;
    @XNode(value="bigIcon")
    protected String bigIcon;
    @XNode(value="bigIcon-expanded")
    protected String bigIconExpanded;
    @XNode(value="label")
    protected String label;
    protected Map<String, SubType> allowedSubTypes;
    @XNodeList(value="deniedSubtypes/type", type=String[].class, componentType=String.class)
    protected String[] deniedSubTypes;
    @XNode(value="default-view")
    protected String defaultView;
    @XNode(value="create-view")
    protected String createView;
    @XNode(value="edit-view")
    protected String editView;
    @XNode(value="description")
    protected String description;
    @XNode(value="category")
    protected String category;
    protected Map<String, TypeView> views;
    @XNodeList(value="actions/action", type=String[].class, componentType=String.class)
    protected String[] actions;
    @XNodeList(value="layout/widget", type=FieldWidget[].class, componentType=FieldWidget.class)
    protected FieldWidget[] layout;
    @XNodeMap(value="layouts", key="@mode", type=HashMap.class, componentType=Layouts.class)
    Map<String, Layouts> layouts;
    @XNode(value="@remove")
    protected boolean remove = false;

    @XNodeList(value="subtypes/type", type=ArrayList.class, componentType=SubType.class)
    public void addSubType(List<SubType> subTypes) {
        if (this.allowedSubTypes == null) {
            this.allowedSubTypes = new HashMap<String, SubType>();
        }
        for (SubType currentSubType : subTypes) {
            SubType subTypeToMerge = this.allowedSubTypes.get(currentSubType.name);
            if (subTypeToMerge == null) {
                this.allowedSubTypes.put(currentSubType.name, currentSubType);
                continue;
            }
            List<String> currentSubTypeHidden = currentSubType.getHidden();
            List<String> subTypeToMergeHidden = subTypeToMerge.getHidden();
            for (String hidden : currentSubTypeHidden) {
                if (subTypeToMergeHidden.contains(hidden)) continue;
                subTypeToMergeHidden.add(hidden);
            }
        }
    }

    public String[] getActions() {
        return this.actions;
    }

    public void setActions(String[] actions) {
        this.actions = actions;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getBigIcon() {
        return this.bigIcon;
    }

    public void setBigIcon(String bigIcon) {
        this.bigIcon = bigIcon;
    }

    public String getBigIconExpanded() {
        return this.bigIconExpanded;
    }

    public void setBigIconExpanded(String bigIconExpanded) {
        this.bigIconExpanded = bigIconExpanded;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Deprecated
    public FieldWidget[] getLayout() {
        return this.layout;
    }

    @Deprecated
    public void setLayout(FieldWidget[] layout) {
        this.layout = layout;
    }

    public String[] getLayouts(String mode) {
        return this.getLayouts(mode, "any");
    }

    public String[] getLayouts(String mode, String defaultMode) {
        if (this.layouts != null) {
            Layouts layouts = this.layouts.get(mode);
            if (layouts == null && defaultMode != null) {
                layouts = this.layouts.get(defaultMode);
            }
            if (layouts != null) {
                return layouts.getLayouts();
            }
        }
        return null;
    }

    public Map<String, Layouts> getLayouts() {
        return Collections.unmodifiableMap(this.layouts);
    }

    public void setLayouts(Map<String, Layouts> layouts) {
        this.layouts = layouts;
    }

    public String getDefaultView() {
        return this.defaultView;
    }

    public void setDefaultView(String defaultView) {
        this.defaultView = defaultView;
    }

    public String getCreateView() {
        return this.createView;
    }

    public void setCreateView(String createView) {
        this.createView = createView;
    }

    public String getEditView() {
        return this.editView;
    }

    public void setEditView(String editView) {
        this.editView = editView;
    }

    public TypeView[] getViews() {
        return this.views.values().toArray(new TypeView[this.views.size()]);
    }

    @XNodeList(value="views/view", type=TypeView[].class, componentType=TypeView.class)
    public void setViews(TypeView[] views) {
        this.views = new HashMap<String, TypeView>();
        for (TypeView view : views) {
            this.views.put(view.getId(), view);
        }
    }

    public TypeView getView(String viewId) {
        return this.views.get(viewId);
    }

    public void setView(TypeView view) {
        this.views.put(view.getId(), view);
    }

    public String[] getDeniedSubTypes() {
        return this.deniedSubTypes;
    }

    public void setDeniedSubTypes(String[] deniedSubTypes) {
        this.deniedSubTypes = deniedSubTypes;
    }

    public Map<String, SubType> getAllowedSubTypes() {
        return this.allowedSubTypes;
    }

    public void setAllowedSubTypes(Map<String, SubType> allowedSubTypes) {
        this.allowedSubTypes = allowedSubTypes;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Type.class.getSimpleName());
        buf.append(" {");
        buf.append("id: ");
        buf.append(this.id);
        buf.append('}');
        return buf.toString();
    }

    public String getIconExpanded() {
        return this.iconExpanded;
    }

    public void setIconExpanded(String iconExpanded) {
        this.iconExpanded = iconExpanded;
    }
}

