/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.admin.management;

import java.io.File;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.admin.management.FileResource;
import org.nuxeo.ecm.webengine.model.view.TemplateView;

public class FileContainerResource {
    protected File root;
    protected boolean isReadOnly;

    public FileContainerResource(File root) {
        this(root, false);
    }

    public FileContainerResource(File root, boolean isReadOnly) {
        this.root = root;
        this.isReadOnly = isReadOnly;
    }

    public File getRoot() {
        return this.root;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @GET
    @Produces(value={"application/atom+xml"})
    public Object listFiles() {
        File[] files = this.root.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        return new TemplateView((Object)this, "resources.ftl").arg("root", (Object)this.root.getName()).arg("resources", (Object)files);
    }

    @POST
    public Response postFile(@QueryParam(value="file") String file, @QueryParam(value="dir") String dir) {
        if (this.isReadOnly) {
            return Response.status((int)403).build();
        }
        boolean isDir = false;
        String name = null;
        if (file == null) {
            if (dir == null) {
                return Response.status((int)403).build();
            }
            name = dir;
            isDir = true;
        } else {
            name = file;
        }
        if (name.contains("..")) {
            return Response.status((int)403).build();
        }
        File f = new File(this.root, name);
        if (isDir) {
            f.mkdirs();
            return Response.ok().build();
        }
        f.getParentFile().mkdirs();
        HttpServletRequest req = WebEngine.getActiveContext().getRequest();
        try {
            FileUtils.copyToFile((InputStream)req.getInputStream(), (File)f);
            return Response.ok().build();
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @Path(value="{name}")
    public Object getFile(@PathParam(value="name") String name) {
        File file = new File(this.root, name);
        if (file.isDirectory()) {
            return new FileContainerResource(file, this.isReadOnly);
        }
        return new FileResource(file, this.isReadOnly);
    }

    @PUT
    public Response updateFile() {
        if (this.isReadOnly) {
            return Response.status((int)403).build();
        }
        if (!this.root.exists()) {
            this.root.mkdirs();
        } else {
            this.root.setLastModified(new Date().getTime());
        }
        return Response.ok().build();
    }

    @DELETE
    public Response deleteFile() {
        if (this.isReadOnly) {
            return Response.status((int)403).build();
        }
        if (!this.root.isDirectory()) {
            return Response.status((int)404).build();
        }
        FileUtils.deleteTree((File)this.root);
        return Response.ok().build();
    }

    public String getLastModified(File file) {
        return FileContainerResource.formatDate(new Date(file.lastModified()));
    }

    public static String formatDate(Date date) {
        StringBuilder sb = new StringBuilder();
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTime(date);
        sb.append(c.get(1));
        sb.append('-');
        int f = c.get(2);
        if (f < 9) {
            sb.append('0');
        }
        sb.append(f + 1);
        sb.append('-');
        f = c.get(5);
        if (f < 10) {
            sb.append('0');
        }
        sb.append(f);
        sb.append('T');
        f = c.get(11);
        if (f < 10) {
            sb.append('0');
        }
        sb.append(f);
        sb.append(':');
        f = c.get(12);
        if (f < 10) {
            sb.append('0');
        }
        sb.append(f);
        sb.append(':');
        f = c.get(13);
        if (f < 10) {
            sb.append('0');
        }
        sb.append(f);
        sb.append('.');
        f = c.get(14);
        if (f < 100) {
            sb.append('0');
        }
        if (f < 10) {
            sb.append('0');
        }
        sb.append(f);
        sb.append('Z');
        return sb.toString();
    }
}

