/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.core.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.Comment;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.JbpmTaskService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbpmTaskServiceImpl
implements JbpmTaskService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(JbpmTaskServiceImpl.class);

    public void createTask(CoreSession coreSession, NuxeoPrincipal principal, DocumentModel document, String taskName, List<String> prefixedActorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, Serializable> taskVariables) throws NuxeoJbpmException {
        if (createOneTaskPerActor) {
            for (String prefixedActorId : prefixedActorIds) {
                this.createTask(coreSession, principal, document, taskName, Collections.singletonList(prefixedActorId), false, directive, comment, dueDate, taskVariables);
            }
        } else {
            try {
                String[] prefixedActorIdsArray = prefixedActorIds.toArray(new String[prefixedActorIds.size()]);
                TaskInstance task = new TaskInstance();
                task.setName(taskName);
                task.setCreate(new Date());
                task.setPooledActors(prefixedActorIdsArray);
                task.setDueDate(dueDate);
                if (!StringUtils.isEmpty((String)comment)) {
                    task.addComment(new Comment(principal.getName(), comment));
                }
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put(JbpmService.VariableName.documentId.name(), document.getId());
                variables.put(JbpmService.VariableName.documentRepositoryName.name(), document.getRepositoryName());
                variables.put(JbpmService.VariableName.initiator.name(), principal.getName());
                variables.put(JbpmService.TaskVariableName.directive.name(), directive);
                variables.put(JbpmTaskService.TaskVariableName.createdFromTaskService.name(), "true");
                if (taskVariables != null) {
                    variables.putAll(taskVariables);
                }
                task.setVariables(variables);
                this.getJbpmService().saveTaskInstances(Collections.singletonList(task));
                HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
                ArrayList<String> notificationRecipients = new ArrayList<String>();
                notificationRecipients.add(this.getTaskInitiator(task));
                notificationRecipients.addAll(prefixedActorIds);
                eventProperties.put("recipients", (Serializable)notificationRecipients.toArray(new String[notificationRecipients.size()]));
                this.notifyEvent(coreSession, document, principal, task, "worfklowTaskAssigned", eventProperties, comment, null);
                this.notifyEvent(coreSession, document, principal, task, "worfklowTaskAssigned", eventProperties, comment, null);
            }
            catch (ClientException e) {
                throw new NuxeoJbpmException((Throwable)e);
            }
        }
    }

    public void acceptTask(CoreSession coreSession, NuxeoPrincipal principal, TaskInstance task, String comment) throws NuxeoJbpmException {
        this.endTask(coreSession, principal, task, comment, "workflowTaskCompleted", true);
    }

    public void rejectTask(CoreSession coreSession, NuxeoPrincipal principal, TaskInstance task, String comment) throws NuxeoJbpmException {
        this.endTask(coreSession, principal, task, comment, "workflowTaskRejected", false);
    }

    public void endTask(CoreSession coreSession, NuxeoPrincipal principal, TaskInstance task, String comment, String eventName, boolean isValidated) throws NuxeoJbpmException {
        if (!this.canEndTask(principal, task)) {
            throw new NuxeoJbpmException(String.format("User with id '%s' cannot end this task", principal.getName()));
        }
        try {
            JbpmService jbpmService = this.getJbpmService();
            if (!StringUtils.isEmpty((String)comment)) {
                // empty if block
            }
            HashMap<String, String> taskVariables = new HashMap<String, String>();
            taskVariables.put(JbpmService.TaskVariableName.validated.name(), String.valueOf(isValidated));
            task.setVariable(JbpmService.TaskVariableName.validated.name(), (Object)String.valueOf(isValidated));
            jbpmService.endTask(Long.valueOf(task.getId()), null, taskVariables, null, null, principal);
            HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
            ArrayList<String> notificationRecipients = new ArrayList<String>();
            notificationRecipients.add(this.getTaskInitiator(task));
            notificationRecipients.addAll(task.getPooledActors());
            eventProperties.put("recipients", notificationRecipients);
            DocumentModel document = null;
            String docId = (String)task.getVariable(JbpmService.VariableName.documentId.name());
            String docRepo = (String)task.getVariable(JbpmService.VariableName.documentRepositoryName.name());
            if (coreSession.getRepositoryName().equals(docRepo)) {
                try {
                    document = coreSession.getDocument((DocumentRef)new IdRef(docId));
                }
                catch (Exception e) {
                    log.error((Object)String.format("Could not fetch document with id '%s:%s' for notification", docRepo, docId), (Throwable)e);
                }
            } else {
                log.error((Object)String.format("Could not resolve document for notification: document is on repository '%s' and given session is on repository '%s'", docRepo, coreSession.getRepositoryName()));
            }
            this.notifyEvent(coreSession, document, principal, task, eventName, eventProperties, comment, null);
        }
        catch (Exception e) {
            throw new NuxeoJbpmException((Throwable)e);
        }
    }

    public boolean canEndTask(NuxeoPrincipal principal, TaskInstance task) throws NuxeoJbpmException {
        if (task != null && !task.isCancelled() && !task.hasEnded()) {
            return principal.isAdministrator() || principal.getName().equals(this.getTaskInitiator(task)) || this.isTaskAssignedToUser(task, principal);
        }
        return false;
    }

    protected String getTaskInitiator(TaskInstance task) {
        return (String)task.getVariable(JbpmService.VariableName.initiator.name());
    }

    protected boolean isTaskAssignedToUser(TaskInstance task, NuxeoPrincipal user) {
        if (task != null && user != null) {
            ArrayList<String> actors = new ArrayList<String>();
            List groups = user.getAllGroups();
            String actorId = "user:" + user.getName();
            actors.add(actorId);
            for (String s : groups) {
                actors.add("group:" + s);
            }
            if (actors.contains(task.getActorId())) {
                return true;
            }
            Set pooled = task.getPooledActors();
            if (pooled != null) {
                for (PooledActor pa : pooled) {
                    if (!actors.contains(pa.getActorId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected JbpmService getJbpmService() {
        try {
            return (JbpmService)Framework.getLocalService(JbpmService.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Jbpm service is not deployed.", e);
        }
    }

    protected EventProducer getEventProducer() throws ClientException {
        try {
            return (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected void notifyEvent(CoreSession coreSession, DocumentModel document, NuxeoPrincipal principal, TaskInstance task, String eventId, Map<String, Serializable> properties, String comment, String category) throws ClientException {
        if (category == null) {
            category = "eventDocumentCategory";
        }
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        EventContextImpl eventContext = null;
        if (document != null) {
            properties.put("repositoryName", (Serializable)((Object)document.getRepositoryName()));
            properties.put("sessionId", (Serializable)((Object)coreSession.getSessionId()));
            properties.put("documentLifeCycle", (Serializable)((Object)document.getCurrentLifeCycleState()));
            eventContext = new DocumentEventContext(coreSession, (Principal)principal, document);
        } else {
            eventContext = new EventContextImpl(coreSession, (Principal)principal);
        }
        properties.put("comment", (Serializable)((Object)comment));
        properties.put("category", (Serializable)((Object)category));
        properties.put("taskInstance", (Serializable)task);
        eventContext.setProperties(properties);
        Event event = eventContext.newEvent(eventId);
        this.getEventProducer().fireEvent(event);
    }
}

