/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.core.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.db.GraphSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.jbpm.JbpmActorsListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmOperation;
import org.nuxeo.ecm.platform.jbpm.JbpmSecurityPolicy;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmRuntimeException;
import org.nuxeo.ecm.platform.jbpm.core.service.JbpmSynchronization;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbpmServiceImpl
implements JbpmService {
    private static final Log log = LogFactory.getLog(JbpmServiceImpl.class);
    private static final String FROM_ORG_JBPM_TASKMGMT_EXE_TASK_INSTANCE_TI_WHERE_TI_END_IS_NULL = "from org.jbpm.taskmgmt.exe.TaskInstance ti where ti.end is null";
    protected Map<String, List<String>> typeFilters;
    private EventProducer eventProducer;
    private JbpmConfiguration configuration;
    private UserManager userManager;
    public static final ThreadLocal<JbpmContext> contexts = new ThreadLocal();
    private final Map<String, JbpmSecurityPolicy> securityPolicies = new HashMap<String, JbpmSecurityPolicy>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable executeJbpmOperation(JbpmOperation operation) throws NuxeoJbpmException {
        JbpmContext context = this.getContext();
        Serializable result = null;
        try {
            result = operation.run(context);
        }
        finally {
            if (this.isTransactionEnabled(context)) {
                context.close();
            }
        }
        return result;
    }

    protected JbpmContext getContext() {
        JbpmContext context = contexts.get();
        if (!(context != null && context.getSession().isConnected() || this.isTransactionEnabled(context = this.configuration.createJbpmContext()))) {
            contexts.set(context);
            context.getSession().getTransaction().registerSynchronization((Synchronization)new JbpmSynchronization(context));
        }
        return context;
    }

    public JbpmConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isTransactionEnabled(JbpmContext context) {
        DbPersistenceServiceFactory factory = (DbPersistenceServiceFactory)context.getServiceFactory("persistence");
        return factory.isTransactionEnabled();
    }

    protected void setConfiguration(JbpmConfiguration configuration) {
        this.configuration = configuration;
    }

    public List<TaskInstance> getCurrentTaskInstances(final NuxeoPrincipal currentUser, final JbpmListFilter filter) throws NuxeoJbpmException {
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public ArrayList<TaskInstance> run(JbpmContext context) throws NuxeoJbpmException {
                return JbpmServiceImpl.this.getCurrentTaskInstancesInternal(currentUser, filter, context);
            }
        }));
    }

    private ArrayList<TaskInstance> getCurrentTaskInstancesInternal(NuxeoPrincipal currentUser, JbpmListFilter filter, JbpmContext context) {
        if (currentUser == null) {
            throw new IllegalStateException("Null current user");
        }
        context.setActorId("user:" + currentUser.getName());
        List<String> groups = JbpmServiceImpl.getActorsAndGroup(currentUser);
        ArrayList tis = this.getPooledAndActorTaskInstances(context, groups);
        if (filter != null) {
            tis = filter.filter(context, null, tis, currentUser);
        }
        return tis;
    }

    protected ArrayList<TaskInstance> getPooledAndActorTaskInstances(JbpmContext context, List<String> groups) {
        HashSet<TaskInstance> tis = new HashSet<TaskInstance>();
        tis.addAll(context.getTaskMgmtSession().findTaskInstances(groups));
        tis.addAll(context.getTaskMgmtSession().findPooledTaskInstances(groups));
        this.eagerLoadTaskInstances(tis);
        return this.toArrayList(tis);
    }

    protected void eagerLoadTaskInstances(Collection<TaskInstance> tis) {
        for (TaskInstance ti : tis) {
            this.eagerLoadTaskInstance(ti);
        }
    }

    protected <T> ArrayList<T> toArrayList(Collection<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : list) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public ProcessInstance createProcessInstance(final NuxeoPrincipal user, final String processDefinitionName, final DocumentModel dm, final Map<String, Serializable> variables, final Map<String, Serializable> transientVariables) throws NuxeoJbpmException {
        return (ProcessInstance)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public ProcessInstance run(JbpmContext context) throws NuxeoJbpmException {
                TaskInstance ti;
                String initiatorActorId = "user:";
                if (user != null) {
                    initiatorActorId = initiatorActorId + user.getName();
                    context.setActorId(initiatorActorId);
                }
                ProcessInstance pi = context.newProcessInstance(processDefinitionName);
                if (initiatorActorId != null) {
                    pi.getContextInstance().setVariable(JbpmService.VariableName.initiator.name(), (Object)initiatorActorId);
                }
                if (variables != null) {
                    pi.getContextInstance().addVariables(variables);
                }
                if (transientVariables != null) {
                    pi.getContextInstance().setTransientVariables(transientVariables);
                }
                if (dm != null) {
                    pi.getContextInstance().setVariable(JbpmService.VariableName.documentId.name(), (Object)dm.getId());
                    pi.getContextInstance().setVariable(JbpmService.VariableName.documentRepositoryName.name(), (Object)dm.getRepositoryName());
                }
                if ((ti = pi.getTaskMgmtInstance().createStartTaskInstance()) == null) {
                    pi.signal();
                } else {
                    ti.end();
                }
                return pi;
            }
        });
    }

    public List<ProcessInstance> getCurrentProcessInstances(final NuxeoPrincipal principal, final JbpmListFilter filter) throws NuxeoJbpmException {
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public ArrayList<ProcessInstance> run(JbpmContext context) throws NuxeoJbpmException {
                if (principal == null) {
                    throw new IllegalStateException("Null principal");
                }
                List<String> actorsName = JbpmServiceImpl.getActorsAndGroup(principal);
                ArrayList initiatorPD = JbpmServiceImpl.this.getProcessInstances(context, actorsName);
                if (filter != null) {
                    initiatorPD = filter.filter(context, null, initiatorPD, principal);
                }
                return JbpmServiceImpl.this.toArrayList(initiatorPD);
            }
        }));
    }

    protected ArrayList<ProcessInstance> getProcessInstances(JbpmContext context, List<String> actorsName) {
        ArrayList<ProcessInstance> initiatorPD = new ArrayList<ProcessInstance>();
        if (actorsName == null) {
            return initiatorPD;
        }
        Session session = context.getSession();
        List list = session.getNamedQuery(JbpmService.HibernateQueries.NuxeoHibernateQueries_getProcessInstancesForInitiator.name()).setParameterList("initiators", actorsName).list();
        initiatorPD.addAll(list);
        this.eagerLoadProcessInstances(initiatorPD);
        return initiatorPD;
    }

    protected static List<String> getActorsAndGroup(NuxeoPrincipal principal) {
        ArrayList<String> actors = new ArrayList<String>();
        String name = principal.getName();
        if (!name.startsWith("user:")) {
            name = "user:" + name;
        }
        actors.add(name);
        for (String group : principal.getAllGroups()) {
            if (!group.startsWith("group:")) {
                group = "group:" + group;
            }
            actors.add(group);
        }
        return actors;
    }

    protected List<ProcessDefinition> getProcessDefinitions(NuxeoPrincipal user) throws NuxeoJbpmException {
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public ArrayList<ProcessDefinition> run(JbpmContext context) {
                GraphSession session = context.getGraphSession();
                return JbpmServiceImpl.this.toArrayList(session.findLatestProcessDefinitions());
            }
        }));
    }

    public DocumentModel getDocumentModel(final TaskInstance ti, final NuxeoPrincipal user) throws NuxeoJbpmException {
        return (DocumentModel)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                String repoId;
                String docId;
                TaskInstance sessionedTi;
                ProcessInstance pi;
                if (user != null) {
                    context.setActorId("user:" + user.getName());
                }
                if ((pi = (sessionedTi = context.getTaskInstance(ti.getId())).getProcessInstance()) == null) {
                    docId = (String)sessionedTi.getVariable(JbpmService.VariableName.documentId.name());
                    repoId = (String)sessionedTi.getVariable(JbpmService.VariableName.documentRepositoryName.name());
                } else {
                    ProcessInstance sessionedPi = context.getProcessInstance(pi.getId());
                    ContextInstance ci = sessionedPi.getContextInstance();
                    docId = (String)ci.getVariable(JbpmService.VariableName.documentId.name());
                    repoId = (String)ci.getVariable(JbpmService.VariableName.documentRepositoryName.name());
                }
                return JbpmServiceImpl.this.getDocumentModel(user, docId, repoId);
            }
        });
    }

    protected DocumentModel getDocumentModel(NuxeoPrincipal user, String docId, String repoId) throws NuxeoJbpmException {
        DocumentModel result;
        CoreSession session = this.getCoreSession(repoId, user);
        try {
            result = session.getDocument((DocumentRef)new IdRef(docId));
        }
        catch (ClientException e) {
            throw new NuxeoJbpmException((Throwable)e);
        }
        finally {
            this.closeCoreSession(session);
        }
        return result;
    }

    public DocumentModel getDocumentModel(final ProcessInstance pi, final NuxeoPrincipal user) throws NuxeoJbpmException {
        return (DocumentModel)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                ProcessInstance sessionedPi = context.getProcessInstance(pi.getId());
                ContextInstance ci = sessionedPi.getContextInstance();
                String docId = (String)ci.getVariable(JbpmService.VariableName.documentId.name());
                String repoId = (String)ci.getVariable(JbpmService.VariableName.documentRepositoryName.name());
                return JbpmServiceImpl.this.getDocumentModel(user, docId, repoId);
            }
        });
    }

    public List<ProcessInstance> getProcessInstances(final DocumentModel dm, final NuxeoPrincipal user, final JbpmListFilter jbpmListFilter) throws NuxeoJbpmException {
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public ArrayList<ProcessInstance> run(JbpmContext context) throws NuxeoJbpmException {
                if (user != null) {
                    context.setActorId("user:" + user.getName());
                }
                ArrayList result = new ArrayList();
                Session session = context.getSession();
                List list = session.getNamedQuery(JbpmService.HibernateQueries.NuxeoHibernateQueries_getProcessInstancesForDoc.name()).setParameter("docId", (Object)dm.getId()).setParameter("repoId", (Object)dm.getRepositoryName()).list();
                for (ProcessInstance pi : list) {
                    if (!JbpmServiceImpl.this.getPermission(pi, JbpmSecurityPolicy.Action.read, dm, user).booleanValue()) continue;
                    pi.getProcessDefinition();
                    result.add(pi);
                    pi.getContextInstance().getVariables().size();
                }
                if (jbpmListFilter != null) {
                    result = jbpmListFilter.filter(context, dm, result, user);
                }
                JbpmServiceImpl.this.eagerLoadProcessInstances(result);
                return result;
            }
        }));
    }

    private void eagerLoadProcessInstances(Collection<ProcessInstance> pis) {
        for (ProcessInstance pi : pis) {
            if (pi == null) continue;
            pi.getProcessDefinition().getName();
            pi.getContextInstance().getVariables();
            for (Object ti : pi.getTaskMgmtInstance().getTaskInstances()) {
                ((TaskInstance)ti).getName();
            }
        }
    }

    public List<TaskInstance> getTaskInstances(final DocumentModel dm, final NuxeoPrincipal user, final JbpmListFilter filter) throws NuxeoJbpmException {
        assert (dm != null);
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public ArrayList<TaskInstance> run(JbpmContext context) throws NuxeoJbpmException {
                List tis;
                HashSet<TaskInstance> tisSet = new HashSet<TaskInstance>();
                if (user != null) {
                    tis = JbpmServiceImpl.this.getCurrentTaskInstancesInternal(user, null, context);
                    tisSet.addAll(tis);
                } else {
                    tis = context.getSession().createQuery(JbpmServiceImpl.FROM_ORG_JBPM_TASKMGMT_EXE_TASK_INSTANCE_TI_WHERE_TI_END_IS_NULL).list();
                    tisSet.addAll(tis);
                }
                ArrayList result = JbpmServiceImpl.this.getTaskInstancesForDocument(dm, tisSet);
                if (filter != null) {
                    result = filter.filter(context, dm, result, user);
                }
                return result;
            }
        }));
    }

    protected void eagerLoadTaskInstance(TaskInstance ti) {
        if (ti.getPooledActors() != null) {
            ti.getPooledActors().size();
        }
        if (ti.getVariableInstances() != null) {
            ti.getVariableInstances().size();
        }
        if (ti.getComments() != null) {
            ti.getComments().size();
        }
        if (ti.getToken() != null) {
            ti.getToken().getId();
        }
    }

    protected ArrayList<TaskInstance> getTaskInstancesForDocument(DocumentModel dm, Set<TaskInstance> tisSet) {
        ArrayList<Long> donePi = new ArrayList<Long>();
        ArrayList<Long> useDocument = new ArrayList<Long>();
        ArrayList<TaskInstance> result = new ArrayList<TaskInstance>();
        for (TaskInstance ti : tisSet) {
            String repoId;
            String docId;
            ProcessInstance pi = ti.getProcessInstance();
            if (pi == null) {
                docId = (String)ti.getVariable(JbpmService.VariableName.documentId.name());
                repoId = (String)ti.getVariable(JbpmService.VariableName.documentRepositoryName.name());
                if (!docId.equals(dm.getId()) || !repoId.equals(dm.getRepositoryName())) continue;
                this.eagerLoadTaskInstance(ti);
                result.add(ti);
                continue;
            }
            if (!donePi.contains(pi.getId())) {
                docId = (String)pi.getContextInstance().getVariable(JbpmService.VariableName.documentId.name());
                repoId = (String)pi.getContextInstance().getVariable(JbpmService.VariableName.documentRepositoryName.name());
                donePi.add(pi.getId());
                if (docId.equals(dm.getId()) && repoId.equals(dm.getRepositoryName())) {
                    useDocument.add(pi.getId());
                }
                if (!useDocument.contains(pi.getId())) continue;
                this.eagerLoadTaskInstance(ti);
                result.add(ti);
                continue;
            }
            if (!useDocument.contains(pi.getId())) continue;
            this.eagerLoadTaskInstance(ti);
            result.add(ti);
        }
        return result;
    }

    protected CoreSession getCoreSession(String repositoryName, NuxeoPrincipal principal) throws NuxeoJbpmException {
        HashMap<String, NuxeoPrincipal> context = new HashMap<String, NuxeoPrincipal>();
        context.put("principal", principal);
        try {
            return CoreInstance.getInstance().open(repositoryName, context);
        }
        catch (ClientException e) {
            throw new NuxeoJbpmException((Throwable)e);
        }
    }

    protected void closeCoreSession(CoreSession session) {
        CoreInstance.getInstance().close(session);
    }

    public void endProcessInstance(final Long processId) throws NuxeoJbpmException {
        this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                context.getProcessInstance(processId.longValue()).end();
                return null;
            }
        });
    }

    public void endTask(final Long taskInstanceId, final String transition, final Map<String, Serializable> taskVariables, final Map<String, Serializable> variables, final Map<String, Serializable> transientVariables, final NuxeoPrincipal principal) throws NuxeoJbpmException {
        this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                boolean hasProcess;
                if (principal != null) {
                    context.setActorId("user:" + principal.getName());
                }
                TaskInstance ti = context.getTaskInstance(taskInstanceId.longValue());
                if (taskVariables != null) {
                    for (String k : taskVariables.keySet()) {
                        ti.setVariableLocally(k, taskVariables.get(k));
                    }
                }
                boolean bl = hasProcess = ti.getProcessInstance() != null;
                if (variables != null) {
                    if (hasProcess) {
                        ti.getProcessInstance().getContextInstance().addVariables(variables);
                    } else {
                        log.error((Object)("Cannot put variables on an isolated task without process: " + variables));
                    }
                }
                if (transientVariables != null) {
                    if (hasProcess) {
                        ti.getProcessInstance().getContextInstance().setTransientVariables(transientVariables);
                    } else {
                        log.error((Object)("Cannot put transient variables on an isolated task without process: " + transientVariables));
                    }
                }
                if (transition == null || transition.equals("")) {
                    ti.end();
                } else {
                    ti.end(transition);
                }
                return null;
            }
        });
    }

    protected NuxeoPrincipal getPrincipal(String user) throws NuxeoJbpmException {
        try {
            return this.getUserManager().getPrincipal(user);
        }
        catch (ClientException e) {
            throw new NuxeoJbpmException((Throwable)e);
        }
    }

    protected UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new NuxeoJbpmRuntimeException((Throwable)e);
            }
        }
        return this.userManager;
    }

    public List<String> getAvailableTransitions(final Long taskInstanceId, final NuxeoPrincipal principal) throws NuxeoJbpmException {
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                if (principal != null) {
                    context.setActorId("user:" + principal.getName());
                }
                return (Serializable)((Object)context.getTaskInstance(taskInstanceId.longValue()).getAvailableTransitions());
            }
        }));
    }

    public ProcessInstance getProcessInstance(final Long processInstanceId) throws NuxeoJbpmException {
        return (ProcessInstance)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                ProcessInstance pi = context.getProcessInstance(processInstanceId.longValue());
                JbpmServiceImpl.this.eagerLoadProcessInstances(Collections.singletonList(pi));
                return pi;
            }
        });
    }

    public List<TaskInstance> getTaskInstances(final Long processInstanceId, final NuxeoPrincipal principal, final JbpmListFilter filter) throws NuxeoJbpmException {
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                if (principal != null) {
                    context.setActorId("user:" + principal.getName());
                }
                Collection tis = context.getProcessInstance(processInstanceId.longValue()).getTaskMgmtInstance().getTaskInstances();
                ArrayList result = new ArrayList();
                for (TaskInstance ti : tis) {
                    JbpmServiceImpl.this.eagerLoadTaskInstance(ti);
                    result.add(ti);
                }
                if (filter != null) {
                    result = filter.filter(context, null, result, principal);
                }
                return result;
            }
        }));
    }

    public void saveTaskInstances(final List<TaskInstance> taskInstances) throws NuxeoJbpmException {
        this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                Session session = context.getSession();
                for (TaskInstance ti : taskInstances) {
                    session.merge((Object)ti);
                }
                return null;
            }
        });
    }

    protected void addSecurityPolicy(String processDefinitionName, JbpmSecurityPolicy securityPolicy) {
        this.securityPolicies.put(processDefinitionName, securityPolicy);
    }

    public List<ProcessDefinition> getProcessDefinitions(final NuxeoPrincipal user, final DocumentModel dm, final JbpmListFilter filter) throws NuxeoJbpmException {
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public ArrayList<ProcessDefinition> run(JbpmContext context) throws NuxeoJbpmException {
                if (user != null) {
                    context.setActorId("user:" + user.getName());
                }
                List pds = context.getGraphSession().findLatestProcessDefinitions();
                ArrayList result = new ArrayList(pds);
                if (filter != null) {
                    result = filter.filter(context, dm, result, user);
                }
                return result;
            }
        }));
    }

    public Boolean getPermission(final ProcessInstance pi, final JbpmSecurityPolicy.Action action, final DocumentModel dm, final NuxeoPrincipal principal) throws NuxeoJbpmException {
        return (Boolean)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) {
                JbpmSecurityPolicy pm;
                Boolean perm;
                ProcessInstance process = context.getProcessInstance(pi.getId());
                String pdName = process.getProcessDefinition().getName();
                if (JbpmServiceImpl.this.securityPolicies.containsKey(pdName) && (perm = (pm = (JbpmSecurityPolicy)JbpmServiceImpl.this.securityPolicies.get(pdName)).checkPermission(process, action, dm, principal)) != null) {
                    return perm;
                }
                return Boolean.TRUE;
            }
        });
    }

    public ProcessInstance persistProcessInstance(final ProcessInstance pi) throws NuxeoJbpmException {
        return (ProcessInstance)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                ProcessInstance sessionedPi = context.getProcessInstance(pi.getId());
                ContextInstance ci = sessionedPi.getContextInstance();
                Map attrs = pi.getContextInstance().getVariables();
                for (String k : attrs.keySet()) {
                    ci.setVariable(k, attrs.get(k));
                }
                Session session = context.getSession();
                session.saveOrUpdate((Object)sessionedPi);
                return context.getProcessInstance(pi.getId());
            }
        });
    }

    public Map<String, List<String>> getTypeFilterConfiguration() {
        return this.typeFilters;
    }

    protected void setTypeFilters(Map<String, List<String>> typeFilters) {
        this.typeFilters = typeFilters;
    }

    public void deleteProcessInstance(final NuxeoPrincipal principal, final Long processId) throws NuxeoJbpmException {
        this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                if (principal != null) {
                    context.setActorId(principal.getName());
                }
                ProcessInstance pi = context.getProcessInstance(processId.longValue());
                Collection tis = pi.getTaskMgmtInstance().getTaskInstances();
                ArrayList<TaskInstance> toRemove = new ArrayList<TaskInstance>();
                for (TaskInstance ti : tis) {
                    if (ti.hasEnded()) continue;
                    toRemove.add(ti);
                }
                for (TaskInstance ti : toRemove) {
                    context.getSession().delete((Object)ti);
                }
                context.getSession().delete((Object)pi);
                return null;
            }
        });
    }

    public ProcessDefinition getProcessDefinitionByName(final String name) throws NuxeoJbpmException {
        return (ProcessDefinition)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                return context.getGraphSession().findLatestProcessDefinition(name);
            }
        });
    }

    public List<ProcessDefinition> getProcessDefinitionsByType(final String type) throws NuxeoJbpmException {
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                List<String> pdsName = JbpmServiceImpl.this.typeFilters.get(type);
                if (pdsName == null) {
                    return new ArrayList();
                }
                ArrayList<ProcessDefinition> pds = new ArrayList<ProcessDefinition>();
                for (String name : pdsName) {
                    pds.add(JbpmServiceImpl.this.getProcessDefinitionByName(name));
                }
                return pds;
            }
        }));
    }

    public List<ProcessInstance> getCurrentProcessInstances(final List<String> actors, final JbpmActorsListFilter filter) throws NuxeoJbpmException {
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) {
                ArrayList processes = JbpmServiceImpl.this.getProcessInstances(context, actors);
                if (filter != null) {
                    processes = filter.filter(context, null, processes, actors);
                }
                return processes;
            }
        }));
    }

    public List<TaskInstance> getCurrentTaskInstances(final List<String> actors, final JbpmActorsListFilter filter) throws NuxeoJbpmException {
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public ArrayList<TaskInstance> run(JbpmContext context) throws NuxeoJbpmException {
                return JbpmServiceImpl.this.getCurrentTaskInstancesInternal(actors, filter, context);
            }
        }));
    }

    private ArrayList<TaskInstance> getCurrentTaskInstancesInternal(List<String> actors, JbpmActorsListFilter filter, JbpmContext context) {
        ArrayList tis = this.getPooledAndActorTaskInstances(context, actors);
        if (filter != null) {
            tis = filter.filter(context, null, tis, actors);
        }
        return tis;
    }

    public List<TaskInstance> getTaskInstances(final DocumentModel dm, final List<String> actors, final JbpmActorsListFilter filter) throws NuxeoJbpmException {
        assert (dm != null);
        return (List)((Object)this.executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public ArrayList<TaskInstance> run(JbpmContext context) throws NuxeoJbpmException {
                HashSet<TaskInstance> tisSet = new HashSet<TaskInstance>();
                ArrayList tis = JbpmServiceImpl.this.getCurrentTaskInstancesInternal(actors, null, context);
                tisSet.addAll(tis);
                ArrayList result = JbpmServiceImpl.this.getTaskInstancesForDocument(dm, tisSet);
                if (filter != null) {
                    result = filter.filter(context, dm, result, actors);
                }
                return result;
            }
        }));
    }

    protected EventProducer getEventProducer() throws Exception {
        if (this.eventProducer == null) {
            this.eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        return this.eventProducer;
    }

    public void notifyEventListeners(String name, String comment, String[] recipients, CoreSession session, NuxeoPrincipal principal, DocumentModel doc) throws ClientException {
        DocumentEventContext ctx = new DocumentEventContext(session, (Principal)principal, doc);
        ctx.setProperty("recipients", (Serializable)recipients);
        ctx.getProperties().put("comment", comment);
        try {
            this.getEventProducer().fireEvent(ctx.newEvent(name));
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }
}

