/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.core.helper;

import java.util.List;
import org.jbpm.graph.exe.ExecutionContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.jbpm.AbstractJbpmHandlerHelper;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.ecm.platform.jbpm.VirtualTaskInstance;
import org.nuxeo.ecm.platform.jbpm.core.helper.AddRightUnrestricted;

public class AddRightsActionHandler
extends AbstractJbpmHandlerHelper {
    private static final long serialVersionUID = 1L;
    private String list;

    protected CoreSession getSystemSession() throws Exception {
        String repositoryName = this.getDocumentRepositoryName();
        try {
            return CoreInstance.getInstance().open(repositoryName, null);
        }
        catch (ClientException e) {
            throw new NuxeoJbpmException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext executionContext) throws Exception {
        this.executionContext = executionContext;
        if (this.nuxeoHasStarted() && this.list != null) {
            List participants = (List)executionContext.getContextInstance().getTransientVariable(this.list);
            if (participants == null) {
                participants = (List)executionContext.getVariable(this.list);
            }
            CoreSession session = null;
            try {
                session = this.getSystemSession();
                DocumentRef docRef = this.getDocumentRef();
                ACP acp = session.getACP(docRef);
                String aclName = this.getACLName();
                ACL acl = acp.getOrCreateACL(aclName);
                String initiator = this.getInitiator();
                if (initiator != null) {
                    if (initiator.startsWith("user:")) {
                        initiator = initiator.substring("user:".length());
                    }
                    acl.add((Object)new ACE(initiator, "ReadWrite", true));
                }
                for (VirtualTaskInstance participant : participants) {
                    for (String pname : participant.getActors()) {
                        if (pname.startsWith("user:")) {
                            pname = pname.substring("user:".length());
                        } else if (pname.startsWith("group:")) {
                            pname = pname.substring("group:".length());
                        }
                        acl.add((Object)new ACE(pname, "Read", true));
                    }
                }
                acp.addACL(acl);
                AddRightUnrestricted runner = new AddRightUnrestricted(session, docRef, acp);
                runner.runUnrestricted();
            }
            finally {
                if (session != null) {
                    this.closeCoreSession(session);
                }
            }
        }
        executionContext.getToken().signal();
    }
}

