/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

class SynchronizationRegistry {
    private static final LogProvider log = Logging.getLogProvider(SynchronizationRegistry.class);
    private List<Synchronization> synchronizations = new ArrayList<Synchronization>();

    SynchronizationRegistry() {
    }

    void registerSynchronization(Synchronization sync) {
        this.synchronizations.add(sync);
    }

    void afterTransactionCompletion(boolean success) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.afterTransactionCompletion", success);
        }
        for (Synchronization sync : this.synchronizations) {
            try {
                sync.afterCompletion(success ? 3 : 4);
            }
            catch (Exception e) {
                log.error("Exception processing transaction Synchronization after completion", e);
            }
        }
        this.synchronizations.clear();
    }

    void beforeTransactionCompletion() {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.beforeTransactionCompletion", new Object[0]);
        }
        for (Synchronization sync : this.synchronizations) {
            try {
                sync.beforeCompletion();
            }
            catch (Exception e) {
                log.error("Exception processing transaction Synchronization before completion", e);
            }
        }
    }
}

