/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.security.auth.login.LoginException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.faces.Selector;
import org.jboss.seam.security.Identity;

@Name(value="org.jboss.seam.security.facesSecurityEvents")
@Scope(value=ScopeType.APPLICATION)
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@BypassInterceptors
@Startup
public class FacesSecurityEvents
extends Selector {
    public String getCookieName() {
        return "org.jboss.seam.security.username";
    }

    @Observer(value={"org.jboss.seam.postCreate.org.jboss.seam.security.identity"})
    public void initCredentialsFromCookie(Identity identity) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null) {
            this.setCookiePath(ctx.getExternalContext().getRequestContextPath());
        }
        identity.setRememberMe(this.isCookieEnabled());
        String username = this.getCookieValue();
        if (username != null) {
            this.setCookieEnabled(true);
            identity.setUsername(username);
            this.postRememberMe(identity);
        }
        this.setDirty();
    }

    @Observer(value={"org.jboss.seam.security.credentialsUpdated"})
    public void credentialsUpdated() {
        this.setDirty();
    }

    @Observer(value={"org.jboss.seam.security.postAuthenticate"})
    public void postAuthenticate(Identity identity) {
        this.setDirty();
        if (!identity.isRememberMe()) {
            this.clearCookieValue();
        }
        this.setCookieValueIfEnabled(identity.getUsername());
    }

    @Observer(value={"org.jboss.seam.security.rememberMe"})
    public void postRememberMe(Identity identity) {
        this.setCookieEnabled(identity.isRememberMe());
    }

    @Observer(value={"org.jboss.seam.security.loginFailed"})
    public void addLoginFailedMessage(LoginException ex) {
        FacesMessages.instance().addFromResourceBundleOrDefault(this.getLoginFailedMessageSeverity(), this.getLoginFailedMessageKey(), this.getLoginFailedMessage(), ex);
    }

    public String getLoginFailedMessage() {
        return "Login failed";
    }

    public FacesMessage.Severity getLoginFailedMessageSeverity() {
        return FacesMessage.SEVERITY_INFO;
    }

    public String getLoginFailedMessageKey() {
        return "org.jboss.seam.loginFailed";
    }

    @Observer(value={"org.jboss.seam.security.loginSuccessful"})
    public void addLoginSuccessfulMessage() {
        FacesMessages.instance().addFromResourceBundleOrDefault(this.getLoginSuccessfulMessageSeverity(), this.getLoginSuccessfulMessageKey(), this.getLoginSuccessfulMessage(), Identity.instance().getUsername());
    }

    public FacesMessage.Severity getLoginSuccessfulMessageSeverity() {
        return FacesMessage.SEVERITY_INFO;
    }

    public String getLoginSuccessfulMessage() {
        return "Welcome, #0";
    }

    public String getLoginSuccessfulMessageKey() {
        return "org.jboss.seam.loginSuccessful";
    }
}

