/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.BijectionInterceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.util.JSF;
import org.jboss.seam.util.Reflections;

@Interceptor(around={BijectionInterceptor.class})
public class ManagedEntityIdentityInterceptor
extends AbstractInterceptor {
    private boolean reentrant;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        if (this.reentrant) {
            return ctx.proceed();
        }
        this.reentrant = true;
        this.entityIdsToRefs(ctx);
        try {
            Object object = ctx.proceed();
            return object;
        }
        finally {
            if (!ManagedEntityIdentityInterceptor.isTransactionRolledBackOrMarkedRollback()) {
                this.entityRefsToIds(ctx);
                this.reentrant = false;
            }
        }
    }

    private static boolean isTransactionRolledBackOrMarkedRollback() {
        try {
            return Transaction.instance().isRolledBackOrMarkedRollback();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void entityRefsToIds(InvocationContext ctx) throws Exception {
        if (this.touchedContextsExist()) {
            Object bean = ctx.getTarget();
            for (Class<?> beanClass = bean.getClass(); beanClass != Object.class; beanClass = beanClass.getSuperclass()) {
                for (Field field : beanClass.getDeclaredFields()) {
                    if (this.ignore(field)) continue;
                    Object value = this.getFieldValue(bean, field);
                    if (value != null) {
                        Object dataModel = null;
                        if (JSF.DATA_MODEL.isInstance(value)) {
                            dataModel = value;
                            value = JSF.getWrappedData(dataModel);
                        }
                        if (this.isRef(value)) {
                            this.saveWrapper(bean, field, dataModel, value);
                            continue;
                        }
                        this.clearWrapper(field);
                        continue;
                    }
                    this.clearWrapper(field);
                }
            }
        }
    }

    public void entityIdsToRefs(InvocationContext ctx) throws Exception {
        if (this.touchedContextsExist()) {
            Object bean = ctx.getTarget();
            for (Class<?> beanClass = bean.getClass(); beanClass != Object.class; beanClass = beanClass.getSuperclass()) {
                for (Field field : beanClass.getDeclaredFields()) {
                    if (this.ignore(field)) continue;
                    Object value = this.getFieldValue(bean, field);
                    Object dataModel = null;
                    if (value != null && JSF.DATA_MODEL.isInstance(value)) {
                        dataModel = value;
                    }
                    this.getFromWrapper(bean, field, dataModel);
                }
            }
        }
    }

    private boolean isRef(Object value) {
        return value instanceof List || value instanceof Map || value instanceof Set || Seam.getEntityClass(value.getClass()) != null;
    }

    private Object getFieldValue(Object bean, Field field) throws Exception {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        Object value = Reflections.get(field, bean);
        return value;
    }

    private boolean ignore(Field field) {
        return Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(In.class);
    }

    private boolean touchedContextsExist() {
        PersistenceContexts touchedContexts = PersistenceContexts.instance();
        return touchedContexts != null && touchedContexts.getTouchedContexts().size() > 0;
    }

    private String getFieldId(Field field) {
        return this.getComponent().getName() + '.' + field.getName();
    }

    private void saveWrapper(Object bean, Field field, Object dataModel, Object value) throws Exception {
        Contexts.getConversationContext().set(this.getFieldId(field), value);
        if (dataModel == null) {
            Reflections.set(field, bean, null);
        } else {
            JSF.setWrappedData(dataModel, null);
        }
    }

    private void clearWrapper(Field field) throws Exception {
        Contexts.getConversationContext().remove(this.getFieldId(field));
    }

    private void getFromWrapper(Object bean, Field field, Object dataModel) throws Exception {
        Object value = Contexts.getConversationContext().get(this.getFieldId(field));
        if (value != null) {
            if (dataModel == null) {
                Reflections.set(field, bean, value);
            } else {
                JSF.setWrappedData(dataModel, value);
            }
        }
    }
}

