/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class SetDataModel
extends DataModel
implements Serializable {
    private static final long serialVersionUID = -616367764778689337L;
    private int rowIndex = -1;
    private List entries;

    public SetDataModel() {
    }

    public SetDataModel(Set set) {
        if (set == null) {
            throw new IllegalArgumentException("null set data");
        }
        this.setWrappedData(set);
    }

    public int getRowCount() {
        if (this.entries == null) {
            return -1;
        }
        return this.entries.size();
    }

    public Object getRowData() {
        if (this.entries == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this.entries.get(this.rowIndex);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Object getWrappedData() {
        return new AbstractSet(){

            public Iterator iterator() {
                return SetDataModel.this.entries.iterator();
            }

            public int size() {
                return SetDataModel.this.entries.size();
            }
        };
    }

    public boolean isRowAvailable() {
        return this.entries != null && this.rowIndex >= 0 && this.rowIndex < this.entries.size();
    }

    public void setRowIndex(int newRowIndex) {
        if (newRowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + newRowIndex);
        }
        int oldRowIndex = this.rowIndex;
        this.rowIndex = newRowIndex;
        if (this.entries != null && oldRowIndex != newRowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent((DataModel)this, newRowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    public void setWrappedData(Object data) {
        this.entries = new ArrayList((Set)data);
        int rowIndex = data != null ? 0 : -1;
        this.setRowIndex(rowIndex);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.rowIndex);
        oos.writeObject(this.entries);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.rowIndex = ois.readInt();
        this.entries = (List)ois.readObject();
    }
}

