/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.jboss.seam.deployment.AbstractScanner;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

public class VFSScanner
extends AbstractScanner {
    private static final LogProvider log = Logging.getLogProvider(VFSScanner.class);

    public VFSScanner(DeploymentStrategy deploymentStrategy) {
        super(deploymentStrategy);
    }

    protected static VirtualFile getRoot(URL url, int parentDepth) throws IOException {
        String relative;
        log.trace("Root url: " + url);
        String urlString = url.toString();
        if (!urlString.startsWith("vfs")) {
            return null;
        }
        int p = urlString.indexOf(":");
        String file = urlString.substring(p + 1);
        URL vfsurl = null;
        File fp = new File(file);
        log.trace("File: " + fp);
        if (fp.exists()) {
            vfsurl = fp.getParentFile().toURL();
            relative = fp.getName();
        } else {
            File curr = fp;
            relative = fp.getName();
            while ((curr = curr.getParentFile()) != null) {
                if (curr.exists()) {
                    vfsurl = curr.toURL();
                    break;
                }
                relative = curr.getName() + "/" + relative;
            }
        }
        log.trace("URL: " + vfsurl + ", relative: " + relative);
        VirtualFile top = VFS.getRoot((URL)vfsurl);
        top = top.getChild(relative);
        while (parentDepth > 0) {
            if (top == null) {
                throw new IllegalArgumentException("Null parent: " + vfsurl + ", relative: " + relative);
            }
            top = top.getParent();
            --parentDepth;
        }
        log.trace("Top: " + top);
        return top;
    }

    public void scanDirectories(File[] directories) {
        for (File dir : directories) {
            try {
                VirtualFile root = VFSScanner.getRoot(dir.toURL(), 0);
                if (root != null) {
                    this.handleRoot(root);
                    continue;
                }
                log.trace("Null root: " + dir);
            }
            catch (IOException e) {
                log.warn("Cannot scan directory " + dir, e);
            }
        }
    }

    public void scanResources(String[] resources) {
        for (String resourceName : resources) {
            try {
                Enumeration<URL> urlEnum = this.getDeploymentStrategy().getClassLoader().getResources(resourceName);
                while (urlEnum.hasMoreElements()) {
                    URL url = urlEnum.nextElement();
                    VirtualFile root = VFSScanner.getRoot(url, resourceName.lastIndexOf(47) > 0 ? 2 : 1);
                    if (root != null) {
                        this.handleRoot(root);
                        continue;
                    }
                    log.trace("Null root: " + url);
                }
            }
            catch (IOException ioe) {
                log.warn("Cannot read resource: " + resourceName, ioe);
            }
        }
    }

    protected void handleRoot(VirtualFile root) throws IOException {
        if (root.isLeaf()) {
            this.getDeploymentStrategy().handle(root.getPathName());
        } else {
            String rootPathName = root.getPathName();
            int rootPathNameLength = rootPathName.length();
            List children = root.getChildrenRecursively();
            for (VirtualFile child : children) {
                int length;
                if (!child.isLeaf()) continue;
                String name = child.getPathName();
                if (name.charAt(length = rootPathNameLength) == '/') {
                    ++length;
                }
                this.getDeploymentStrategy().handle(name.substring(length));
            }
        }
    }
}

