/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EscherRecordHolder {
    private final ArrayList<EscherRecord> escherRecords = new ArrayList();

    public EscherRecordHolder() {
    }

    public EscherRecordHolder(byte[] data, int offset, int size) {
        this();
        this.fillEscherRecords(data, offset, size);
    }

    private void fillEscherRecords(byte[] data, int offset, int size) {
        int bytesRead;
        DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory();
        for (int pos = offset; pos < offset + size; pos += bytesRead + 1) {
            EscherRecord r = recordFactory.createRecord(data, pos);
            this.escherRecords.add(r);
            bytesRead = r.fillFields(data, pos, (EscherRecordFactory)recordFactory);
        }
    }

    public List<EscherRecord> getEscherRecords() {
        return this.escherRecords;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.escherRecords.size() == 0) {
            buffer.append("No Escher Records Decoded").append("\n");
        }
        for (EscherRecord r : this.escherRecords) {
            buffer.append(r.toString());
        }
        return buffer.toString();
    }

    public EscherContainerRecord getEscherContainer() {
        for (EscherRecord er : this.escherRecords) {
            if (!(er instanceof EscherContainerRecord)) continue;
            return (EscherContainerRecord)er;
        }
        return null;
    }

    public EscherRecord findFirstWithId(short id) {
        return EscherRecordHolder.findFirstWithId(id, this.getEscherRecords());
    }

    private static EscherRecord findFirstWithId(short id, List<EscherRecord> records) {
        for (EscherRecord r : records) {
            if (r.getRecordId() != id) continue;
            return r;
        }
        for (EscherRecord r : records) {
            EscherRecord found;
            if (!r.isContainerRecord() || (found = EscherRecordHolder.findFirstWithId(id, r.getChildRecords())) == null) continue;
            return found;
        }
        return null;
    }
}

