/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.tree;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.tree.DefaultDocumentTreeFilter;
import org.nuxeo.ecm.core.api.tree.DefaultDocumentTreeSorter;
import org.nuxeo.ecm.core.api.tree.DocumentTreeFilter;
import org.nuxeo.ecm.core.api.tree.DocumentTreeSorter;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModelService;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.ecm.webapp.tree.TreeManager;
import org.nuxeo.ecm.webapp.tree.TreeManagerPluginDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeManagerImpl
extends DefaultComponent
implements TreeManager {
    private static final long serialVersionUID = 1L;
    public static final String NAME = TreeManager.class.getName();
    public static final String PLUGIN_EXTENSION_POINT = "plugin";
    private static final Log log = LogFactory.getLog(TreeManager.class);
    protected Map<String, Filter> filters;
    protected Map<String, Filter> leafFilters;
    protected Map<String, Sorter> sorters;
    protected Map<String, String> queryModelNames;
    protected Map<String, String> orderableQueryModelNames;

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(TreeManager.class)) {
            return (T)this;
        }
        return null;
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.filters = new HashMap<String, Filter>();
        this.leafFilters = new HashMap<String, Filter>();
        this.sorters = new HashMap<String, Sorter>();
        this.queryModelNames = new HashMap<String, String>();
        this.orderableQueryModelNames = new HashMap<String, String>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.filters = null;
        this.leafFilters = null;
        this.sorters = null;
        this.queryModelNames = null;
        this.orderableQueryModelNames = null;
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PLUGIN_EXTENSION_POINT.equals(extensionPoint)) {
            TreeManagerPluginDescriptor plugin = (TreeManagerPluginDescriptor)contribution;
            String name = plugin.getName();
            if (this.filters.containsKey(name)) {
                log.info((Object)("Overriding filter for plugin " + name));
                this.filters.remove(name);
            }
            log.info((Object)("Registering filter for plugin " + name));
            this.filters.put(name, this.buildFilter(plugin));
            if (this.leafFilters.containsKey(name)) {
                log.info((Object)("Overriding leaf filter for plugin " + name));
                this.leafFilters.remove(name);
            }
            log.info((Object)("Registering leaf filter for plugin " + name));
            this.leafFilters.put(name, this.buildLeafFilter(plugin));
            if (this.sorters.containsKey(name)) {
                log.info((Object)("Overriding sorter for plugin " + name));
                this.sorters.remove(name);
            }
            log.info((Object)("Registering sorter for plugin " + name));
            this.sorters.put(name, this.buildSorter(plugin));
            if (this.queryModelNames.containsKey(name)) {
                log.info((Object)("Overriding query model for plugin " + name));
                this.queryModelNames.remove(name);
            }
            log.info((Object)("Registering query model for plugin " + name));
            this.queryModelNames.put(name, plugin.getQueryModelName());
            if (this.orderableQueryModelNames.containsKey(name)) {
                log.info((Object)("Overriding Orderable query model for plugin " + name));
                this.orderableQueryModelNames.remove(name);
            }
            log.info((Object)("Registering Orderable query model for plugin " + name));
            this.orderableQueryModelNames.put(name, plugin.getOrderableQueryModelName());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PLUGIN_EXTENSION_POINT.equals(extensionPoint)) {
            TreeManagerPluginDescriptor plugin = (TreeManagerPluginDescriptor)contribution;
            String name = plugin.getName();
            if (this.filters.containsKey(name)) {
                log.info((Object)("Unregistering filter for plugin " + name));
                this.filters.remove(name);
            }
            if (this.leafFilters.containsKey(name)) {
                log.info((Object)("Unregistering leaf filter for plugin " + name));
                this.leafFilters.remove(name);
            }
            if (this.sorters.containsKey(name)) {
                log.info((Object)("Unregistering sorter for plugin " + name));
                this.sorters.remove(name);
            }
            if (this.queryModelNames.containsKey(name)) {
                log.info((Object)("Unregistering query model for plugin " + name));
                this.queryModelNames.remove(name);
            }
            if (this.orderableQueryModelNames.containsKey(name)) {
                log.info((Object)("Unregistering Orderable query model for plugin " + name));
                this.orderableQueryModelNames.remove(name);
            }
        }
    }

    protected Filter buildFilter(TreeManagerPluginDescriptor plugin) {
        DefaultDocumentTreeFilter filter = null;
        String filterClass = plugin.getFilterClassName();
        if (filterClass == null || "".equals(filterClass)) {
            filter = new DefaultDocumentTreeFilter();
        } else {
            try {
                Object instance = TreeManagerImpl.class.getClassLoader().loadClass(filterClass).newInstance();
                if (instance instanceof Filter) {
                    filter = (Filter)instance;
                } else {
                    log.error((Object)String.format("Class %s should follow %s interface", filterClass, Filter.class.getName()));
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
        if (filter instanceof DocumentTreeFilter) {
            DocumentTreeFilter treeFilter = (DocumentTreeFilter)filter;
            treeFilter.setIncludedFacets(plugin.getIncludedFacets());
            treeFilter.setExcludedFacets(plugin.getExcludedFacets());
            treeFilter.setExcludedTypes(plugin.getExcludedTypes());
        }
        return filter;
    }

    protected Filter buildLeafFilter(TreeManagerPluginDescriptor plugin) {
        String leafFilterClass = plugin.getLeafFilterClassName();
        if (leafFilterClass == null || "".equals(leafFilterClass)) {
            return null;
        }
        try {
            Object instance = TreeManagerImpl.class.getClassLoader().loadClass(leafFilterClass).newInstance();
            if (instance instanceof Filter) {
                return (Filter)instance;
            }
            log.error((Object)String.format("Class %s should follow %s interface", leafFilterClass, Filter.class.getName()));
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        return null;
    }

    protected Sorter buildSorter(TreeManagerPluginDescriptor plugin) {
        DefaultDocumentTreeSorter sorter = null;
        String sorterClass = plugin.getSorterClassName();
        if (sorterClass == null || "".equals(sorterClass)) {
            sorter = new DefaultDocumentTreeSorter();
        } else {
            try {
                Object instance = TreeManagerImpl.class.getClassLoader().loadClass(sorterClass).newInstance();
                if (instance instanceof Sorter) {
                    sorter = (Sorter)instance;
                } else {
                    log.error((Object)String.format("Class %s should follow %s interface", sorterClass, Sorter.class.getName()));
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
        if (sorter instanceof DocumentTreeSorter) {
            DocumentTreeSorter treeSorter = (DocumentTreeSorter)sorter;
            treeSorter.setSortPropertyPath(plugin.getSortPropertyPath());
        }
        return sorter;
    }

    protected QueryModelDescriptor buildQueryModelDescriptor(String queryModelName) {
        if (queryModelName == null || "".equals(queryModelName)) {
            return null;
        }
        QueryModelService service = (QueryModelService)Framework.getRuntime().getComponent("org.nuxeo.ecm.core.search.api.client.querymodel.QueryModelService");
        return service.getQueryModelDescriptor(queryModelName);
    }

    @Override
    public Filter getFilter(String pluginName) {
        return this.filters.get(pluginName);
    }

    @Override
    public Filter getLeafFilter(String pluginName) {
        return this.leafFilters.get(pluginName);
    }

    @Override
    public Sorter getSorter(String pluginName) {
        return this.sorters.get(pluginName);
    }

    @Override
    public QueryModelDescriptor getQueryModelDescriptor(String pluginName) {
        return this.buildQueryModelDescriptor(this.queryModelNames.get(pluginName));
    }

    @Override
    public QueryModelDescriptor getOrderableQueryModelDescriptor(String pluginName) {
        return this.buildQueryModelDescriptor(this.orderableQueryModelNames.get(pluginName));
    }
}

