/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.tree;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentTreeNodeImpl
implements DocumentTreeNode {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentTreeNodeImpl.class);
    protected final DocumentModel document;
    protected final String sessionId;
    protected final Filter filter;
    protected final Filter leafFilter;
    protected final Sorter sorter;
    protected final QueryModel queryModel;
    protected final QueryModel orderableQueryModel;
    protected Map<Object, DocumentTreeNodeImpl> children;

    public DocumentTreeNodeImpl(DocumentModel document, Filter filter, Filter leafFilter, Sorter sorter, QueryModel queryModel) {
        this(document.getSessionId(), document, filter, leafFilter, sorter, queryModel);
    }

    public DocumentTreeNodeImpl(DocumentModel document, Filter filter, Filter leafFilter, Sorter sorter, QueryModel queryModel, QueryModel orderableQueryModel) {
        this(document.getSessionId(), document, filter, leafFilter, sorter, queryModel, orderableQueryModel);
    }

    public DocumentTreeNodeImpl(String sessionId, DocumentModel document, Filter filter, Filter leafFilter, Sorter sorter, QueryModel queryModel) {
        this(sessionId, document, filter, leafFilter, sorter, queryModel, null);
    }

    public DocumentTreeNodeImpl(String sessionId, DocumentModel document, Filter filter, Filter leafFilter, Sorter sorter, QueryModel queryModel, QueryModel orderableQueryModel) {
        this.document = document;
        this.sessionId = sessionId;
        this.filter = filter;
        this.leafFilter = leafFilter;
        this.sorter = sorter;
        this.queryModel = queryModel;
        this.orderableQueryModel = orderableQueryModel;
    }

    @Deprecated
    public DocumentTreeNodeImpl(DocumentModel document, Filter filter, Sorter sorter) {
        this(document, filter, null, sorter, null);
    }

    @Override
    public List<DocumentTreeNode> getChildren() {
        if (this.children == null) {
            this.fetchChildren();
        }
        ArrayList<DocumentTreeNode> childrenNodes = new ArrayList<DocumentTreeNode>();
        childrenNodes.addAll(this.children.values());
        return childrenNodes;
    }

    public DocumentModel getDocument() {
        return this.document;
    }

    @Override
    public String getId() {
        if (this.document != null) {
            return this.document.getId();
        }
        return null;
    }

    @Override
    public String getPath() {
        if (this.document != null) {
            return this.document.getPathAsString();
        }
        return null;
    }

    public void resetChildren() {
        this.children = null;
    }

    public void fetchChildren() {
        try {
            DocumentModelList documents;
            this.children = new LinkedHashMap<Object, DocumentTreeNodeImpl>();
            if (this.leafFilter != null && this.leafFilter.accept(this.document)) {
                return;
            }
            CoreSession session = CoreInstance.getInstance().getSession(this.sessionId);
            if (this.queryModel == null) {
                Sorter sorterToUse = this.document.hasFacet("Orderable") ? null : this.sorter;
                documents = session.getChildren(this.document.getRef(), null, "Read", this.filter, sorterToUse);
            } else {
                documents = this.document.hasFacet("Orderable") && this.orderableQueryModel != null ? this.orderableQueryModel.getDocuments(session, new Object[]{this.getId()}) : this.queryModel.getDocuments(session, new Object[]{this.getId()});
            }
            for (DocumentModel child : documents) {
                String identifier = child.getId();
                DocumentTreeNodeImpl childNode = new DocumentTreeNodeImpl(session.getSessionId(), child, this.filter, this.leafFilter, this.sorter, this.queryModel, this.orderableQueryModel);
                this.children.put(identifier, childNode);
            }
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
    }
}

