/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.theme.negotiation;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ec.placeful.Annotation;
import org.nuxeo.ecm.platform.ec.placeful.interfaces.PlacefulService;
import org.nuxeo.ecm.webapp.theme.negotiation.LocalThemeConfig;
import org.nuxeo.runtime.api.Framework;

public class LocalThemeHelper {
    private static final Log log = LogFactory.getLog(LocalThemeHelper.class);

    public static PlacefulService getPlacefulServiceBean() {
        PlacefulService placefulService = null;
        try {
            placefulService = (PlacefulService)Framework.getService(PlacefulService.class);
        }
        catch (Exception e) {
            log.error((Object)"Error connecting to PlacefulService", (Throwable)e);
        }
        if (null == placefulService) {
            log.error((Object)"Placeful service not bound");
        }
        return placefulService;
    }

    public static LocalThemeConfig getLocalThemeConfig(DocumentModel doc) {
        PlacefulService placefulService = LocalThemeHelper.getPlacefulServiceBean();
        if (placefulService == null) {
            return null;
        }
        String docId = doc.getId();
        if (docId == null) {
            log.error((Object)"Could not get the current document's uuid.");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("docId", docId);
        List configs = placefulService.getAnnotationListByParamMap(paramMap, "LocalThemeConfig");
        if (!configs.isEmpty()) {
            return (LocalThemeConfig)configs.get(0);
        }
        return null;
    }

    public static void setLocalThemeConfig(String theme, String page, String perspective, String engine, String mode, DocumentModel doc) {
        PlacefulService placefulService = LocalThemeHelper.getPlacefulServiceBean();
        if (placefulService == null) {
            return;
        }
        String docId = doc.getId();
        if (docId == null) {
            log.error((Object)"Could not get the current document's uuid.");
            return;
        }
        LocalThemeHelper.removeLocalThemeConfig(doc);
        if ("".equals(theme)) {
            theme = null;
        }
        if (theme == null || "".equals(page)) {
            page = null;
        }
        if ("".equals(perspective)) {
            perspective = null;
        }
        if ("".equals(engine)) {
            engine = null;
        }
        if ("".equals(mode)) {
            mode = null;
        }
        if (theme != null || page != null || perspective != null || engine != null || mode != null) {
            placefulService.setAnnotation((Annotation)new LocalThemeConfig(theme, page, perspective, engine, mode, docId));
        }
    }

    public static void removeLocalThemeConfig(DocumentModel doc) {
        PlacefulService placefulService = LocalThemeHelper.getPlacefulServiceBean();
        if (placefulService == null) {
            return;
        }
        String docId = doc.getId();
        if (docId == null) {
            log.error((Object)"Could not get the current document's uuid.");
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("docId", docId);
        placefulService.removeAnnotationListByParamMap(paramMap, "LocalThemeConfig");
    }
}

