/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.theme.fragment;

import java.util.Map;
import org.jboss.seam.Component;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ActionService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.SeamContextHelper;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Menu;
import org.nuxeo.theme.models.MenuItem;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.theme.properties.FieldInfo;

public final class ActionFragment
extends AbstractFragment {
    @FieldInfo(type="string", label="category", description="The action category.")
    public String category = "";
    private final ActionService actionService = (ActionService)Framework.getRuntime().getComponent(ActionService.ID);

    public ActionFragment() {
    }

    public ActionFragment(String category) {
        this.category = category;
    }

    public Model getModel() throws ModelException {
        NavigationContext navigationContext;
        ResourcesAccessor resourcesAccessor = (ResourcesAccessor)Component.getInstance((String)"resourcesAccessor");
        Map<String, String> messages = resourcesAccessor.getMessages();
        ActionContext ctx = new ActionContext();
        ctx.put((Object)"SeamContext", (Object)new SeamContextHelper());
        CoreSession documentManager = (CoreSession)Component.getInstance((String)"documentManager");
        ctx.setDocumentManager(documentManager);
        if (documentManager != null) {
            ctx.setCurrentPrincipal((NuxeoPrincipal)documentManager.getPrincipal());
        }
        if ((navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext")) != null) {
            ctx.setCurrentDocument(navigationContext.getCurrentDocument());
        }
        Menu menu = new Menu();
        for (Action action : this.actionService.getActions(this.category, ctx)) {
            String label = action.getLabel();
            String url = action.getLink();
            menu.addItem((Model)new MenuItem(messages.get(label), "", url, true, action.getIcon()));
        }
        return menu;
    }
}

