/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.pagination;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webapp.pagination.ResultsProviderDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ResultsProviderService
extends DefaultComponent {
    public static final String NAME = "org.nuxeo.ecm.webapp.pagination.ResultsProviderService";
    private static final Log log = LogFactory.getLog(ResultsProviderService.class);
    private Map<String, ResultsProviderDescriptor> descriptors;

    public ResultsProviderDescriptor getResultsProviderDescriptor(String descriptorName) {
        return this.descriptors.get(descriptorName);
    }

    public void activate(ComponentContext context) {
        this.descriptors = new HashMap<String, ResultsProviderDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        this.descriptors = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        ResultsProviderDescriptor descriptor = (ResultsProviderDescriptor)contribution;
        this.descriptors.put(descriptor.getName(), descriptor);
        log.debug((Object)("registered ResultsProviderDescriptor: " + descriptor.getName()));
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        ResultsProviderDescriptor descriptor = (ResultsProviderDescriptor)contribution;
        this.descriptors.remove(descriptor.getName());
        log.debug((Object)("unregistered ResultsProviderDescriptor: " + descriptor.getName()));
    }

    public String getFarmNameFor(String providerName) {
        ResultsProviderDescriptor desc = this.descriptors.get(providerName);
        return desc == null ? null : desc.getFarm();
    }
}

