/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.directory;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ejb.Remove;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeDescriptor;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeManager;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeNode;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeService;
import org.nuxeo.runtime.api.Framework;
import org.richfaces.component.UITree;
import org.richfaces.event.NodeExpandedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
@Name(value="directoryTreeManager")
public class DirectoryTreeManagerBean
implements DirectoryTreeManager {
    private static final long serialVersionUID = -5250556791009032616L;
    private static final Log log = LogFactory.getLog(DirectoryTreeManagerBean.class);
    public static final String NODE_SELECTED_MARKER = DirectoryTreeManagerBean.class.getName() + "_NODE_SELECTED_MARKER";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected transient Map<String, DirectoryTreeNode> treeModels;
    protected transient DirectoryTreeService directoryTreeService;
    protected String selectedTree;
    private transient List<DirectoryTreeNode> directoryTrees;

    @Override
    public boolean isInitialized() {
        return this.documentManager != null;
    }

    @Override
    public DirectoryTreeNode get(String treeName) {
        DirectoryTreeNode treeModel;
        if (this.treeModels == null) {
            this.treeModels = new HashMap<String, DirectoryTreeNode>();
        }
        if ((treeModel = this.treeModels.get(treeName)) != null) {
            return treeModel;
        }
        DirectoryTreeDescriptor config = this.getDirectoryTreeService().getDirectoryTreeDescriptor(treeName);
        if (config == null) {
            log.error((Object)("no DirectoryTreeDescriptor registered as " + treeName));
            return null;
        }
        treeModel = new DirectoryTreeNode(0, config, config.getName(), config.getLabel(), "", null);
        this.treeModels.put(treeName, treeModel);
        return treeModel;
    }

    @Override
    public List<String> getDirectoryTreeNames() {
        return this.getDirectoryTreeService().getDirectoryTrees();
    }

    @Override
    public List<DirectoryTreeNode> getDirectoryTrees() {
        if (this.directoryTrees == null) {
            this.directoryTrees = new LinkedList<DirectoryTreeNode>();
            for (String treeName : this.getDirectoryTreeNames()) {
                this.directoryTrees.add(this.get(treeName));
            }
        }
        return this.directoryTrees;
    }

    @Override
    public String getSelectedTreeName() {
        List<String> names;
        if (this.selectedTree == null && !(names = this.getDirectoryTreeNames()).isEmpty()) {
            this.selectedTree = names.get(0);
        }
        return this.selectedTree;
    }

    @Override
    public void setSelectedTreeName(String treeName) {
        this.selectedTree = treeName;
    }

    @Override
    public DirectoryTreeNode getSelectedTree() {
        return this.get(this.getSelectedTreeName());
    }

    protected DirectoryTreeService getDirectoryTreeService() {
        if (this.directoryTreeService != null) {
            return this.directoryTreeService;
        }
        this.directoryTreeService = (DirectoryTreeService)((Object)Framework.getRuntime().getComponent(DirectoryTreeService.NAME));
        return this.directoryTreeService;
    }

    @Override
    public void changeExpandListener(NodeExpandedEvent event) {
        Object value;
        UIComponent component = event.getComponent();
        UITree treeComponent = null;
        if (component instanceof UITree && (value = (treeComponent = (UITree)component).getRowData()) instanceof DirectoryTreeNode) {
            DirectoryTreeNode treeNode = (DirectoryTreeNode)value;
            if (treeNode.isOpen()) {
                treeNode.setOpen(false);
            } else {
                treeNode.setOpen(true);
            }
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        requestMap.put(NODE_SELECTED_MARKER, Boolean.TRUE);
    }

    protected Boolean isNodeExpandEvent() {
        ExternalContext externalContext;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (externalContext = facesContext.getExternalContext()) != null) {
            return Boolean.TRUE.equals(externalContext.getRequestMap().get(NODE_SELECTED_MARKER));
        }
        return false;
    }

    @Override
    public Boolean adviseNodeOpened(UITree treeComponent) {
        if (!this.isNodeExpandEvent().booleanValue()) {
            try {
                DirectoryTreeNode treeNode;
                Object value = treeComponent.getRowData();
                if (value instanceof DirectoryTreeNode && (treeNode = (DirectoryTreeNode)value).isOpened()) {
                    return true;
                }
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    @Override
    @Remove
    @Destroy
    public void destroy() {
    }
}

