/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.cache.LRUCachingMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="documentListingActions")
@Scope(value=ScopeType.CONVERSATION)
public class DocumentListingActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentListingActionsBean.class);
    public static String DEFAULT_LISTING_LAYOUT = "document_listing";
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected LRUCachingMap<String, String> docTolistings = new LRUCachingMap(20);
    protected String currentListingLayoutName = null;
    protected List<String> currentAvailableListingLayoutNames = null;

    public String getLayoutForDocument(DocumentModel doc) {
        if (doc != null) {
            String id = doc.getId();
            if (this.docTolistings.containsKey((Object)id)) {
                return (String)this.docTolistings.get((Object)id);
            }
            List<String> availableLayouts = this.getAvailableLayoutsForDocument(doc);
            if (availableLayouts != null && !availableLayouts.isEmpty()) {
                return availableLayouts.get(0);
            }
        }
        return DEFAULT_LISTING_LAYOUT;
    }

    public void setLayoutForDocument(DocumentModel doc, String layoutName) {
        if (doc == null) {
            log.error((Object)"Cannot set listing layout for null document");
            return;
        }
        String id = doc.getId();
        this.docTolistings.put((Object)id, (Object)layoutName);
        this.currentListingLayoutName = layoutName;
    }

    @Factory(value="currentListingLayoutName", scope=ScopeType.EVENT)
    public String getLayoutForCurrentDocument() {
        if (this.currentListingLayoutName == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.currentListingLayoutName = this.getLayoutForDocument(currentDocument);
        }
        return this.currentListingLayoutName;
    }

    public void setLayoutForCurrentDocument(String layoutName) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.setLayoutForDocument(currentDocument, layoutName);
    }

    public List<String> getAvailableLayoutsForDocument(DocumentModel doc) {
        if (doc == null) {
            return Collections.emptyList();
        }
        TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
        String[] layoutNames = typeInfo.getLayouts("listing", null);
        ArrayList<String> res = new ArrayList<String>();
        if (layoutNames != null && layoutNames.length > 0) {
            res.addAll(Arrays.asList(layoutNames));
        } else {
            res.add(DEFAULT_LISTING_LAYOUT);
        }
        return res;
    }

    @Factory(value="currentAvailableListingLayoutNames", scope=ScopeType.EVENT)
    public List<String> getAvailableLayoutsForCurrentDocument() {
        if (this.currentAvailableListingLayoutNames == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.currentAvailableListingLayoutNames = this.getAvailableLayoutsForDocument(currentDocument);
        }
        return this.currentAvailableListingLayoutNames;
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false, inject=false)
    @BypassInterceptors
    public void documentChanged() {
        this.currentListingLayoutName = null;
        this.currentAvailableListingLayoutNames = null;
    }
}

