/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.clipboard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.webapp.clipboard.Summary;
import org.nuxeo.ecm.webapp.clipboard.SummaryEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryImpl
extends HashMap<String, SummaryEntry>
implements Summary,
Serializable {
    private static final long serialVersionUID = -7791997708511426604L;

    @Override
    public boolean hasChild(SummaryEntry parentEntry) {
        Set key = this.keySet();
        for (String pathRef : key) {
            SummaryEntry summaryEntry = (SummaryEntry)this.get(pathRef);
            if (summaryEntry.getParent() == null || !summaryEntry.getParent().equals(parentEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<SummaryEntry> getChildren(SummaryEntry parentEntry) {
        ArrayList children = null;
        Set key = this.keySet();
        for (String pathRef : key) {
            SummaryEntry summaryEntry = (SummaryEntry)this.get(pathRef);
            if (summaryEntry.getParent() == null || !summaryEntry.getParent().equals(parentEntry)) continue;
            if (children == null) {
                children = new ArrayList();
            }
            children.add(this.get(pathRef));
        }
        return children;
    }

    @Override
    public String displayEntry(StringBuffer sb, SummaryEntry parentEntry) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (parentEntry != null) {
            if (this.hasChild(parentEntry)) {
                parentEntry.setBullet("+ ");
            }
            sb.append(parentEntry.toTreeString());
            List<SummaryEntry> childrens = this.getChildren(parentEntry);
            if (childrens != null && !childrens.isEmpty()) {
                for (SummaryEntry child : childrens) {
                    child.setMarker(parentEntry.getMarker() + child.getMarker() + child.getMarker());
                    this.displayEntry(sb, child);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String toFlatList() {
        StringBuilder sb = new StringBuilder();
        ArrayList entryList = new ArrayList();
        Set key = this.keySet();
        for (String docRef : key) {
            entryList.add(this.get(docRef));
        }
        Collections.sort(entryList);
        for (SummaryEntry summaryEntry : entryList) {
            sb.append(summaryEntry.toFlatString());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toTreeString();
    }

    @Override
    public String toTreeString() {
        return this.displayEntry(null, this.getSummaryRoot());
    }

    @Override
    public SummaryEntry getSummaryRoot() {
        return (SummaryEntry)this.get(new IdRef("0").toString());
    }
}

