/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.bulkedit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkEditHelper {
    public static final String BULK_EDIT_PREFIX = "bulkEdit/";

    private BulkEditHelper() {
    }

    public static List<String> getCommonLayouts(TypeManager typeManager, List<DocumentModel> docs) {
        return BulkEditHelper.getCommonLayouts(typeManager, docs, "edit");
    }

    public static List<String> getCommonLayouts(TypeManager typeManager, List<DocumentModel> docs, String mode) {
        ArrayList<String> layouts = null;
        for (DocumentModel doc : docs) {
            Type type = typeManager.getType(doc.getType());
            List<String> typeLayouts = Arrays.asList(type.getLayouts(mode));
            if (layouts == null) {
                layouts = new ArrayList<String>();
                layouts.addAll(typeLayouts);
                continue;
            }
            layouts.retainAll(typeLayouts);
        }
        return layouts;
    }

    public static List<String> getCommonSchemas(List<DocumentModel> docs) {
        ArrayList<String> schemas = null;
        for (DocumentModel doc : docs) {
            List<String> docSchemas = Arrays.asList(doc.getDeclaredSchemas());
            if (schemas == null) {
                schemas = new ArrayList<String>();
                schemas.addAll(docSchemas);
                continue;
            }
            schemas.retainAll(docSchemas);
        }
        return schemas;
    }

    public static void copyMetadata(CoreSession session, DocumentModel sourceDoc, List<DocumentModel> targetDocs) throws ClientException {
        List<String> propertiesToCopy = BulkEditHelper.getPropertiesToCopy(sourceDoc);
        for (DocumentModel targetDoc : targetDocs) {
            for (String propertyToCopy : propertiesToCopy) {
                targetDoc.setPropertyValue(propertyToCopy, sourceDoc.getPropertyValue(propertyToCopy));
            }
        }
        session.saveDocuments(targetDocs.toArray(new DocumentModel[targetDocs.size()]));
        session.save();
    }

    protected static List<String> getPropertiesToCopy(DocumentModel sourceDoc) {
        ArrayList<String> propertiesToCopy = new ArrayList<String>();
        for (Map.Entry entry : sourceDoc.getContextData().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(BULK_EDIT_PREFIX)) continue;
            String[] properties = key.replace(BULK_EDIT_PREFIX, "").split(" ");
            Serializable value = (Serializable)entry.getValue();
            if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            propertiesToCopy.addAll(Arrays.asList(properties));
        }
        return propertiesToCopy;
    }
}

