/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.base;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.action.TypesTool;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputController {
    private static final Log log = LogFactory.getLog(InputController.class);
    @In(create=true)
    protected ActionManager actionManager;
    @In(create=true)
    protected TypeManager typeManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected EventManager eventManager;
    @In(required=false, create=true)
    @Deprecated
    protected DocumentModel currentDocument;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected TypesTool typesTool;
    @In(create=true, required=false)
    protected Principal currentUser;

    public void removeDocumentFromList(List<DocumentModel> documentList, DocumentModel document) {
        if (null == document) {
            log.error((Object)"Received nul doc, not removing anything...");
            return;
        }
        log.debug((Object)("Removing document " + document.getId() + " from list..."));
        for (int i = 0; i < documentList.size(); ++i) {
            if (!documentList.get(i).getRef().equals(document.getRef())) continue;
            documentList.remove(i);
        }
    }

    public void logDocumentWithTitle(String someLogString, DocumentModel document) {
        if (null != document) {
            log.trace((Object)('[' + this.getClass().getSimpleName() + "] " + someLogString + ' ' + document.getId()));
            log.debug((Object)("CURRENT DOC PATH: " + document.getPathAsString()));
        } else {
            log.trace((Object)('[' + this.getClass().getSimpleName() + "] " + someLogString + " NULL DOC"));
        }
    }

    public void logDocumentWithName(String someLogString, DocumentModel document) {
        if (null != document) {
            log.debug((Object)('[' + this.getClass().getSimpleName() + "] " + someLogString + ' ' + document.getName()));
        } else {
            log.debug((Object)('[' + this.getClass().getSimpleName() + "] " + someLogString + " NULL DOC"));
        }
    }

    protected List<DocumentRef> extractReferences(List<DocumentModel> documents) {
        ArrayList<DocumentRef> references = new ArrayList<DocumentRef>();
        for (DocumentModel docModel : documents) {
            references.add(docModel.getRef());
        }
        return references;
    }

    protected void setFacesMessage(String msg) {
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, this.resourcesAccessor.getMessages().get(msg), new Object[0]);
    }

    public boolean getAdministrator() {
        boolean administrator = false;
        if (this.currentUser instanceof NuxeoPrincipal) {
            administrator = ((NuxeoPrincipal)this.currentUser).isAdministrator();
        }
        return administrator;
    }

    @Deprecated
    public String computeOutcome(String actionOutcome) {
        return null;
    }
}

