/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.types.SubType;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="typesTool")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class TypesTool
implements Serializable {
    private static final long serialVersionUID = -5037578301250616973L;
    private static final Log log = LogFactory.getLog(TypesTool.class);
    private static final int COLUMN_SIZE = 4;
    private static String DEFAULT_CATEGORY = "misc";
    @In
    private transient TypeManager typeManager;
    private Map<String, List<List<Type>>> typesMap;
    private Type selectedType;
    @In(create=true)
    private transient NavigationContext navigationContext;

    @Observer(value={"contentRootSelectionChanged", "documentSelectionChanged", "domainSelectionChanged"}, create=false, inject=false)
    @BypassInterceptors
    public void resetTypesList() {
        this.typesMap = null;
    }

    public void populateTypesList() {
        Type docType;
        boolean set = false;
        DocumentModel model = this.getCurrentItem();
        if (model != null && (docType = this.typeManager.getType(model.getType())) != null) {
            this.typesMap = new HashMap<String, List<List<Type>>>();
            Map allowedSubTypes = docType.getAllowedSubTypes();
            Set allowedSubTypesKeySet = allowedSubTypes.keySet();
            for (String currentKey : allowedSubTypesKeySet) {
                Type subType;
                SubType currentSubType = (SubType)allowedSubTypes.get(currentKey);
                boolean addElement = true;
                List subTypesHiddenInCreation = currentSubType.getHidden();
                if (subTypesHiddenInCreation != null && subTypesHiddenInCreation.contains("create")) {
                    addElement = false;
                }
                if (!addElement || (subType = this.typeManager.getType(currentKey)) == null) continue;
                String key = subType.getCategory();
                if (key == null) {
                    key = DEFAULT_CATEGORY;
                }
                if (!this.typesMap.containsKey(key)) {
                    this.typesMap.put(key, new ArrayList());
                    this.typesMap.get(key).add(new ArrayList());
                }
                this.typesMap.get(key).get(0).add(subType);
            }
            this.typesMap = this.organizeType();
            set = true;
        }
        if (!set) {
            this.typesMap = new HashMap<String, List<List<Type>>>();
        }
    }

    private Map<String, List<List<Type>>> organizeType() {
        HashMap<String, List<List<Type>>> newTypesMap = new HashMap<String, List<List<Type>>>();
        Set<Map.Entry<String, List<List<Type>>>> typeEntrySet = this.typesMap.entrySet();
        for (Map.Entry<String, List<List<Type>>> set : typeEntrySet) {
            List<List<Type>> typeList = set.getValue();
            ArrayList newList = new ArrayList();
            int index = 0;
            newList.add(index, new ArrayList());
            for (Type type : typeList.get(0)) {
                List currentList = (List)newList.get(index);
                if (currentList == null) {
                    newList.add(index, new ArrayList());
                }
                currentList.add(type);
                if (currentList.size() % 4 != 0) continue;
                newList.add(++index, new ArrayList());
            }
            newTypesMap.put(set.getKey(), newList);
        }
        return newTypesMap;
    }

    public List<String> getAllowedSubTypesFor(String docType) {
        Type documentType = this.typeManager.getType(docType);
        ArrayList<String> allowedSubTypes = new ArrayList<String>(documentType.getAllowedSubTypes().keySet());
        return allowedSubTypes;
    }

    public Type getSelectedType() {
        if (this.selectedType != null) {
            log.debug((Object)("Returning selected type with id: " + this.selectedType.getId()));
        }
        return this.selectedType;
    }

    public void setSelectedType(Type type) {
        if (this.typesMap == null) {
            this.populateTypesList();
        }
        this.selectedType = type;
    }

    @Factory(value="typesMap", scope=ScopeType.EVENT)
    public Map<String, List<List<Type>>> getTypesList() {
        if (this.typesMap == null) {
            this.populateTypesList();
        }
        this.selectedType = null;
        return this.typesMap;
    }

    public void setTypesList(Map<String, List<List<Type>>> typesList) {
        this.typesMap = typesList;
    }

    public Type getType(String typeName) {
        return this.typeManager.getType(typeName);
    }

    public boolean hasType(String typeName) {
        return this.typeManager.hasType(typeName);
    }

    protected DocumentModel getCurrentItem() {
        return this.navigationContext.getCurrentDocument();
    }
}

