/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentableDocumentAdapter
implements CommentableDocument {
    private static final long serialVersionUID = 2996381735762615450L;
    final DocumentModel docModel;

    public CommentableDocumentAdapter(DocumentModel docModel) {
        this.docModel = docModel;
    }

    private static CommentManager getCommentManager() {
        try {
            return (CommentManager)Framework.getService(CommentManager.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public DocumentModel addComment(DocumentModel comment) throws ClientException {
        CommentManager commentManager = CommentableDocumentAdapter.getCommentManager();
        return commentManager.createComment(this.docModel, comment);
    }

    @Deprecated
    public DocumentModel addComment(String comment) throws ClientException {
        CommentManager commentManager = CommentableDocumentAdapter.getCommentManager();
        return commentManager.createComment(this.docModel, comment);
    }

    @Override
    public DocumentModel addComment(DocumentModel parent, DocumentModel comment) throws ClientException {
        CommentManager commentManager = CommentableDocumentAdapter.getCommentManager();
        return commentManager.createComment(this.docModel, parent, comment);
    }

    @Override
    public void removeComment(DocumentModel comment) throws ClientException {
        CommentManager commentManager = CommentableDocumentAdapter.getCommentManager();
        commentManager.deleteComment(this.docModel, comment);
    }

    @Override
    public List<DocumentModel> getComments() throws ClientException {
        CommentManager commentManager = CommentableDocumentAdapter.getCommentManager();
        return commentManager.getComments(this.docModel);
    }

    @Override
    public List<DocumentModel> getComments(DocumentModel parent) throws ClientException {
        CommentManager commentManager = CommentableDocumentAdapter.getCommentManager();
        return commentManager.getComments(this.docModel, parent);
    }
}

