/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.core.listener;

import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.runtime.api.Framework;

public class DigestComputer
implements EventListener {
    private Boolean initDone = false;
    private List<String> xpathFields;
    private String digestAlgo = "sha-256";
    private Boolean activateDigestComputation = false;
    private static final Log log = LogFactory.getLog(DigestComputer.class);

    private Boolean initIfNeeded() {
        if (!this.initDone.booleanValue()) {
            try {
                FileManager fm = (FileManager)Framework.getService(FileManager.class);
                this.xpathFields = fm.getFields();
                this.digestAlgo = fm.getDigestAlgorithm();
                this.activateDigestComputation = fm.isDigestComputingEnabled();
                this.initDone = true;
            }
            catch (Exception e) {
                log.error((Object)"Unable to initialize Digest Computer Core Listener", (Throwable)e);
            }
        }
        return this.initDone;
    }

    private void addDigestToDocument(DocumentModel doc) {
        for (String xpathField : this.xpathFields) {
            Property blobProp = null;
            try {
                blobProp = doc.getProperty(xpathField);
            }
            catch (PropertyException e) {
                log.debug((Object)("Property " + xpathField + " not found on doc, skipping"));
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            if (blobProp == null || blobProp.isPhantom() || !blobProp.isDirty()) continue;
            try {
                String digest;
                Blob blob = (Blob)blobProp.getValue();
                if (blob == null || (digest = this.computeDigest(blob)).equals(blob.getDigest())) continue;
                blob.setDigest(digest);
            }
            catch (Exception e) {
                log.error((Object)"Error while trying to save blob digest", (Throwable)e);
            }
        }
    }

    private String computeDigest(Blob blob) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(this.digestAlgo);
        if (!blob.isPersistent()) {
            blob = blob.persist();
        }
        DigestInputStream dis = new DigestInputStream(blob.getStream(), md);
        while (dis.available() > 0) {
            dis.read();
        }
        byte[] b = md.digest();
        return Base64.encodeBytes((byte[])b);
    }

    public void handleEvent(Event event) throws ClientException {
        if (!this.initIfNeeded().booleanValue()) {
            return;
        }
        if (!this.activateDigestComputation.booleanValue()) {
            return;
        }
        EventContext ctx = event.getContext();
        String evt = event.getName();
        if (("aboutToCreate".equals(evt) || "beforeDocumentModification".equals(evt)) && ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc = docCtx.getSourceDocument();
            if (doc == null || doc.isProxy()) {
                return;
            }
            this.addDigestToDocument(doc);
        }
    }
}

