/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.core.listener;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.filemanager.core.listener.AbstractUnicityChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousUnicityCheckListener
extends AbstractUnicityChecker
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(AsynchronousUnicityCheckListener.class);

    public void handleEvent(EventBundle events) throws ClientException {
        if (!this.isUnicityCheckEnabled()) {
            return;
        }
        if (events.containsEventName("documentCreated") || events.containsEventName("documentModified")) {
            ArrayList<String> uuids = new ArrayList<String>();
            for (Event event : events) {
                DocumentEventContext docCtx;
                DocumentModel doc2Check;
                EventContext ctx;
                if (!"documentCreated".equals(event.getName()) && !"documentModified".equals(event.getName()) || !((ctx = event.getContext()) instanceof DocumentEventContext) || (doc2Check = (docCtx = (DocumentEventContext)ctx).getSourceDocument()).isProxy() || uuids.contains(doc2Check.getId())) continue;
                uuids.add(doc2Check.getId());
                this.doUnicityCheck(doc2Check, docCtx.getCoreSession(), event);
            }
        }
    }

    @Override
    protected void onDuplicatedDoc(CoreSession session, Principal principal, DocumentModel newDoc, List<DocumentLocation> existingDocs, Event event) {
        log.info((Object)"Duplicated file detected");
        this.raiseDuplicatedFileEvent(session, principal, newDoc, existingDocs);
    }
}

