/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.dashboard;

import java.util.Date;
import java.util.List;
import org.jbpm.graph.exe.Comment;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.dashboard.DashBoardItem;

public class DashBoardItemImpl
implements DashBoardItem {
    private static final long serialVersionUID = 919752175741886376L;
    protected Long id;
    protected String name;
    protected String description;
    protected Date startDate;
    protected Date dueDate;
    protected boolean expired;
    protected final String directive;
    protected String comment;
    protected DocumentModel document;
    protected TaskInstance task;

    public DashBoardItemImpl(TaskInstance task, DocumentModel document) {
        this.task = task;
        this.document = document;
        this.id = task.getId();
        this.name = task.getName();
        this.description = task.getDescription();
        this.dueDate = task.getDueDate();
        this.startDate = task.getCreate();
        this.directive = (String)task.getVariableLocally(JbpmService.TaskVariableName.directive.name());
        List comments = task.getComments();
        this.comment = comments != null && !comments.isEmpty() ? ((Comment)comments.get(comments.size() - 1)).getMessage() : null;
        if (this.dueDate != null) {
            Date today = new Date();
            this.expired = this.dueDate.before(today);
        } else {
            this.expired = false;
        }
    }

    public String getComment() {
        return this.comment;
    }

    public String getDescription() {
        return this.description;
    }

    public DocumentRef getDocRef() {
        return this.document.getRef();
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Long getId() {
        return this.id;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getName() {
        return this.name;
    }

    public String getDirective() {
        return this.directive;
    }

    public DocumentModel getDocument() {
        return this.document;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public TaskInstance getTaskInstance() {
        return this.task;
    }
}

