/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.JbpmContext;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskVariableFilter
implements JbpmListFilter {
    private static final long serialVersionUID = 1L;
    Map<String, Serializable> variables = new HashMap<String, Serializable>();

    public TaskVariableFilter(String variableName, String variableValue) {
        this.variables.put(variableName, (Serializable)((Object)variableValue));
    }

    public TaskVariableFilter(Map<String, Serializable> variables) {
        if (variables != null) {
            this.variables.putAll(variables);
        }
    }

    @Override
    public <T> ArrayList<T> filter(JbpmContext jbpmContext, DocumentModel document, ArrayList<T> list, NuxeoPrincipal principal) {
        ArrayList<TaskInstance> result = new ArrayList<TaskInstance>();
        if (!this.variables.isEmpty()) {
            for (T t : list) {
                boolean isOk = true;
                TaskInstance task = (TaskInstance)t;
                for (Map.Entry<String, Serializable> variable : this.variables.entrySet()) {
                    Object value = task.getVariable(variable.getKey());
                    if (value == null && variable.getValue() == null || value != null && value.equals(variable.getValue())) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                result.add(task);
            }
        }
        return result;
    }
}

