/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.jbpm.TaskList;
import org.nuxeo.ecm.platform.jbpm.VirtualTaskInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListImpl
implements TaskList {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TaskListImpl.class);
    protected DocumentModel doc;

    public TaskListImpl(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public void addTask(VirtualTaskInstance task) {
        try {
            ArrayList newList = new ArrayList();
            List currentList = (List)((Object)this.doc.getPropertyValue("ntl:tasks"));
            if (currentList != null) {
                newList.addAll(currentList);
            }
            HashMap<String, Object> persone = new HashMap<String, Object>();
            persone.put("taskUsers", task.getActors());
            persone.put("directive", task.getDirective());
            persone.put("comment", task.getComment());
            persone.put("dueDate", task.getDueDate());
            newList.add(persone);
            this.doc.setPropertyValue("ntl:tasks", newList);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<VirtualTaskInstance> getTasks() {
        try {
            ArrayList<VirtualTaskInstance> mls = new ArrayList<VirtualTaskInstance>();
            List participants = (List)((Object)this.doc.getPropertyValue("ntl:tasks"));
            if (participants != null) {
                for (Map participant : participants) {
                    VirtualTaskInstance task = new VirtualTaskInstance();
                    task.setActors((List)participant.get("taskUsers"));
                    task.setDirective((String)participant.get("directive"));
                    task.setComment((String)participant.get("comment"));
                    GregorianCalendar calendar = (GregorianCalendar)participant.get("dueDate");
                    if (calendar != null) {
                        task.setDueDate(calendar.getTime());
                    }
                    mls.add(task);
                }
            }
            return mls;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public DocumentModel getDocument() {
        return this.doc;
    }

    @Override
    public String getName() {
        try {
            return this.doc.getTitle();
        }
        catch (ClientException e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    public String getUUID() {
        return this.doc.getId();
    }
}

