/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm;

import java.util.HashMap;
import java.util.List;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.DecisionHandler;
import org.jbpm.taskmgmt.def.AssignmentHandler;
import org.jbpm.taskmgmt.def.TaskControllerHandler;
import org.jbpm.taskmgmt.exe.Assignable;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJbpmHandlerHelper
implements ActionHandler,
AssignmentHandler,
DecisionHandler,
TaskControllerHandler {
    private static final long serialVersionUID = 1L;
    protected transient JbpmService jbpmService;
    protected ExecutionContext executionContext;

    public void execute(ExecutionContext executionContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void assign(Assignable assignable, ExecutionContext executionContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String decide(ExecutionContext executionContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void initializeTaskVariables(TaskInstance taskInstance, ContextInstance contextInstance, Token token) {
        throw new UnsupportedOperationException();
    }

    public void submitTaskVariables(TaskInstance taskInstance, ContextInstance contextInstance, Token token) {
        throw new UnsupportedOperationException();
    }

    public JbpmService getJbpmService() throws Exception {
        if (this.jbpmService == null) {
            this.jbpmService = (JbpmService)Framework.getService(JbpmService.class);
        }
        return this.jbpmService;
    }

    protected String getDocumentRepositoryName() {
        return this.getStringVariable(JbpmService.VariableName.documentRepositoryName.name());
    }

    protected String getDocumentId() {
        return this.getStringVariable(JbpmService.VariableName.documentId.name());
    }

    protected DocumentRef getDocumentRef() {
        return new IdRef(this.getDocumentId());
    }

    protected String getInitiator() {
        return this.getSwimlaneUser(JbpmService.VariableName.initiator.name());
    }

    protected String getEndLifecycleTransition() {
        return this.getStringVariable(JbpmService.VariableName.endLifecycleTransition.name());
    }

    protected List<String> getParticipants() {
        return (List)this.executionContext.getContextInstance().getVariable(JbpmService.VariableName.participants.name());
    }

    protected CoreSession getCoreSession(NuxeoPrincipal principal) throws Exception {
        String repositoryName = this.getDocumentRepositoryName();
        HashMap<String, NuxeoPrincipal> context = new HashMap<String, NuxeoPrincipal>();
        context.put("principal", principal);
        try {
            return CoreInstance.getInstance().open(repositoryName, context);
        }
        catch (ClientException e) {
            throw new NuxeoJbpmException(e);
        }
    }

    protected String getSwimlaneUser(String swimlaneName) {
        return this.executionContext.getTaskMgmtInstance().getSwimlaneInstance(swimlaneName).getActorId();
    }

    protected void closeCoreSession(CoreSession session) {
        CoreInstance.getInstance().close(session);
    }

    protected void followTransition(NuxeoPrincipal principal, DocumentRef docRef, String transition) throws Exception {
        CoreSession coreSession = this.getCoreSession(principal);
        coreSession.followTransition(docRef, transition);
        coreSession.save();
        this.closeCoreSession(coreSession);
    }

    protected String getStringVariable(String name) {
        return (String)this.executionContext.getContextInstance().getVariable(name);
    }

    protected boolean nuxeoHasStarted() {
        return Framework.getRuntime() != null;
    }

    protected String getACLName() {
        Long pid = this.executionContext.getProcessInstance().getId();
        return AbstractJbpmHandlerHelper.getProcessACLName(pid);
    }

    public static String getProcessACLName(Long pid) {
        return "WORKFLOW_ACL_" + pid;
    }

    public Object getTransientVariable(String name) {
        return this.executionContext.getContextInstance().getTransientVariable(name);
    }
}

