/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.api.security.SecuritySummaryEntry;
import org.nuxeo.ecm.core.api.security.impl.SecuritySummaryEntryImpl;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.DefaultPermissionProvider;
import org.nuxeo.ecm.core.security.PermissionDescriptor;
import org.nuxeo.ecm.core.security.PermissionProviderLocal;
import org.nuxeo.ecm.core.security.PermissionVisibilityDescriptor;
import org.nuxeo.ecm.core.security.SecurityException;
import org.nuxeo.ecm.core.security.SecurityManager;
import org.nuxeo.ecm.core.security.SecurityPolicyDescriptor;
import org.nuxeo.ecm.core.security.SecurityPolicyService;
import org.nuxeo.ecm.core.security.SecurityPolicyServiceImpl;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.security.SecurityService");
    public static final String PERMISSIONS_EXTENSION_POINT = "permissions";
    private static final String PERMISSIONS_VISIBILITY_EXTENSION_POINT = "permissionsVisibility";
    private static final String POLICIES_EXTENSION_POINT = "policies";
    private static final Log log = LogFactory.getLog(SecurityService.class);
    private PermissionProviderLocal permissionProvider;
    private SecurityPolicyService securityPolicyService;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.permissionProvider = new DefaultPermissionProvider();
        this.securityPolicyService = new SecurityPolicyServiceImpl();
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        this.permissionProvider = null;
        this.securityPolicyService = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PERMISSIONS_EXTENSION_POINT.equals(extensionPoint) && contribution instanceof PermissionDescriptor) {
            this.permissionProvider.registerDescriptor((PermissionDescriptor)contribution);
        } else if (PERMISSIONS_VISIBILITY_EXTENSION_POINT.equals(extensionPoint) && contribution instanceof PermissionVisibilityDescriptor) {
            this.permissionProvider.registerDescriptor((PermissionVisibilityDescriptor)contribution);
        } else if (POLICIES_EXTENSION_POINT.equals(extensionPoint) && contribution instanceof SecurityPolicyDescriptor) {
            this.securityPolicyService.registerDescriptor((SecurityPolicyDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PERMISSIONS_EXTENSION_POINT.equals(extensionPoint) && contribution instanceof PermissionDescriptor) {
            this.permissionProvider.unregisterDescriptor((PermissionDescriptor)contribution);
        } else if (PERMISSIONS_VISIBILITY_EXTENSION_POINT.equals(extensionPoint) && contribution instanceof PermissionVisibilityDescriptor) {
            this.permissionProvider.unregisterDescriptor((PermissionVisibilityDescriptor)contribution);
        } else if (POLICIES_EXTENSION_POINT.equals(extensionPoint) && contribution instanceof SecurityPolicyDescriptor) {
            this.securityPolicyService.unregisterDescriptor((SecurityPolicyDescriptor)contribution);
        }
    }

    public PermissionProvider getPermissionProvider() {
        return this.permissionProvider;
    }

    public static void invalidateCache(Session session, String username) {
        session.getRepository().getNuxeoSecurityManager().invalidateCache(session);
    }

    public boolean arePoliciesRestrictingPermission(String permission) {
        return this.securityPolicyService.arePoliciesRestrictingPermission(permission);
    }

    public boolean arePoliciesExpressibleInQuery() {
        return this.securityPolicyService.arePoliciesExpressibleInQuery();
    }

    public Collection<SQLQuery.Transformer> getPoliciesQueryTransformers() {
        return this.securityPolicyService.getPoliciesQueryTransformers();
    }

    public boolean checkPermission(Document doc, Principal principal, String permission) throws SecurityException {
        String username = principal.getName();
        if ("system".equals(username)) {
            return true;
        }
        if (principal instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator()) {
            return true;
        }
        SecurityManager securityManager = doc.getSession().getRepository().getNuxeoSecurityManager();
        String[] resolvedPermissions = this.getPermissionsToCheck(permission);
        String[] additionalPrincipals = SecurityService.getPrincipalsToCheck(principal);
        ACP acp = securityManager.getMergedACP(doc);
        Access access = this.securityPolicyService.checkPermission(doc, acp, principal, permission, resolvedPermissions, additionalPrincipals);
        if (access != null && !Access.UNKNOWN.equals(access)) {
            return access.toBoolean();
        }
        if (acp == null) {
            return false;
        }
        access = acp.getAccess(additionalPrincipals, resolvedPermissions);
        return access.toBoolean();
    }

    public String[] getPermissionsToCheck(String permission) {
        String[] groups = this.permissionProvider.getPermissionGroups(permission);
        if (groups == null) {
            return new String[]{permission, "Everything"};
        }
        String[] perms = new String[groups.length + 2];
        perms[0] = permission;
        System.arraycopy(groups, 0, perms, 1, groups.length);
        perms[groups.length + 1] = "Everything";
        return perms;
    }

    public static String[] getPrincipalsToCheck(Principal principal) {
        List userGroups = null;
        if (principal instanceof NuxeoPrincipal) {
            userGroups = ((NuxeoPrincipal)principal).getAllGroups();
        }
        if (userGroups == null) {
            return new String[]{principal.getName(), "Everyone"};
        }
        int size = userGroups.size();
        String[] groups = new String[size + 2];
        userGroups.toArray(groups);
        groups[size] = principal.getName();
        groups[size + 1] = "Everyone";
        return groups;
    }

    public static List<SecuritySummaryEntry> getSecuritySummary(Document doc, Boolean includeParents) {
        ArrayList<SecuritySummaryEntry> result = new ArrayList<SecuritySummaryEntry>();
        if (doc == null) {
            return result;
        }
        SecurityService.addChildrenToSecuritySummary(doc, result);
        if (includeParents.booleanValue()) {
            SecurityService.addParentsToSecurirySummary(doc, result);
        }
        return result;
    }

    private static SecuritySummaryEntry createSecuritySummaryEntry(Document doc) throws DocumentException {
        return new SecuritySummaryEntryImpl(new IdRef(doc.getUUID()), new PathRef(doc.getPath()), doc.getSession().getSecurityManager().getACP(doc));
    }

    private static void addParentsToSecurirySummary(Document doc, List<SecuritySummaryEntry> summary) {
        Document parent;
        try {
            parent = doc.getParent();
        }
        catch (DocumentException e) {
            return;
        }
        if (parent == null) {
            return;
        }
        try {
            ACL[] acls;
            SecuritySummaryEntry entry = SecurityService.createSecuritySummaryEntry(parent);
            ACP acp = entry.getAcp();
            if (acp != null && (acls = acp.getACLs()) != null && acls.length > 0) {
                summary.add(0, entry);
            }
        }
        catch (DocumentException e) {
            return;
        }
        SecurityService.addParentsToSecurirySummary(parent, summary);
    }

    private static void addChildrenToSecuritySummary(Document doc, List<SecuritySummaryEntry> summary) {
        try {
            SecuritySummaryEntry entry = SecurityService.createSecuritySummaryEntry(doc);
            ACP acp = entry.getAcp();
            if (acp != null && acp.getACLs() != null && acp.getACLs().length > 0) {
                summary.add(entry);
            }
        }
        catch (DocumentException e) {
            return;
        }
        try {
            Iterator<Document> iter = doc.getChildren();
            while (iter.hasNext()) {
                Document child = iter.next();
                SecurityService.addChildrenToSecuritySummary(child, summary);
            }
        }
        catch (DocumentException e) {
            return;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(PermissionProvider.class)) {
            return (T)this.permissionProvider;
        }
        if (adapter.isAssignableFrom(SecurityPolicyService.class)) {
            return (T)this.securityPolicyService;
        }
        return adapter.cast((Object)this);
    }
}

