/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.security.Principal;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;

public class LockSecurityPolicy
extends AbstractSecurityPolicy {
    private static final Log log = LogFactory.getLog(LockSecurityPolicy.class);

    public Access checkPermission(Document doc, ACP mergedAcp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        Access access = Access.UNKNOWN;
        try {
            String username = principal.getName();
            String lock = doc.getLock();
            if (lock != null && !lock.startsWith(username + ':') && resolvedPermissions != null && Arrays.asList(resolvedPermissions).contains("Write")) {
                access = Access.DENY;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get lock status on document ", (Throwable)e);
        }
        return access;
    }

    public boolean isRestrictingPermission(String permission) {
        assert (permission.equals("Browse"));
        return false;
    }

    public boolean isExpressibleInQuery() {
        return true;
    }

    public SQLQuery.Transformer getQueryTransformer() {
        return SQLQuery.Transformer.IDENTITY;
    }
}

