/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.extensions;

import java.util.ArrayList;
import java.util.Collection;
import org.nuxeo.ecm.core.lifecycle.LifeCycleState;
import org.nuxeo.ecm.core.lifecycle.impl.LifeCycleStateImpl;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleStateConfiguration {
    private static final String TAG_STATE = "state";
    private static final String TAG_TRANSITION = "transition";
    private static final String ATTR_STATE_NAME = "name";
    private static final String ATTR_STATE_DESCRIPTION = "description";
    private static final String ATTR_STATE_INITIAL = "initial";
    private final Element element;

    public LifeCycleStateConfiguration(Element element) {
        this.element = element;
    }

    private static Collection<String> getAllowedTransitionsFor(Element element) {
        ArrayList<String> transitions = new ArrayList<String>();
        NodeList elements = element.getElementsByTagName(TAG_TRANSITION);
        int len = elements.getLength();
        for (int i = 0; i < len; ++i) {
            Element elt = (Element)elements.item(i);
            transitions.add(elt.getTextContent());
        }
        return transitions;
    }

    public Collection<LifeCycleState> getStates() {
        ArrayList<LifeCycleState> states = new ArrayList<LifeCycleState>();
        NodeList elements = this.element.getElementsByTagName(TAG_STATE);
        int len = elements.getLength();
        for (int i = 0; i < len; ++i) {
            Element element = (Element)elements.item(i);
            states.add(new LifeCycleStateImpl(element.getAttribute(ATTR_STATE_NAME), element.getAttribute(ATTR_STATE_DESCRIPTION), LifeCycleStateConfiguration.getAllowedTransitionsFor(element), Boolean.valueOf(element.getAttribute(ATTR_STATE_INITIAL))));
        }
        return states;
    }
}

