/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Session;

public class DocumentResolver
implements Serializable {
    private static final long serialVersionUID = -2261223293670404568L;
    private static final Log log = LogFactory.getLog(DocumentResolver.class);

    public static Document resolveReference(Session session, DocumentRef docRef) throws DocumentException {
        if (docRef == null) {
            throw new DocumentException("Invalid reference (null)");
        }
        int type = docRef.type();
        Object ref = docRef.reference();
        if (ref == null) {
            throw new DocumentException("Invalid reference (null)");
        }
        switch (type) {
            case 1: {
                return session.getDocumentByUUID((String)ref);
            }
            case 2: {
                return session.resolvePath((String)ref);
            }
        }
        log.error((Object)("Invalid document reference type: " + type));
        return null;
    }
}

