/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.dashboard.workflow;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.dashboard.DashBoardItem;
import org.nuxeo.ecm.platform.jbpm.dashboard.DashBoardItemImpl;
import org.nuxeo.ecm.platform.jbpm.dashboard.DocumentProcessItem;
import org.nuxeo.ecm.platform.jbpm.dashboard.DocumentProcessItemImpl;
import org.nuxeo.ecm.platform.jbpm.dashboard.WorkflowDashBoard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="workflowDashBoardActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class WorkflowDashBoardActions
implements Serializable,
WorkflowDashBoard {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient JbpmService jbpmService;
    protected Collection<DocumentProcessItem> currentUserProcesses;
    protected Collection<DashBoardItem> currentUserTasks;
    @In(required=false)
    protected transient Principal currentUser;
    private static final Log log = LogFactory.getLog(WorkflowDashBoardActions.class);

    public Collection<DashBoardItem> computeDashboardItems() throws ClientException {
        if (this.currentUserTasks == null) {
            this.currentUserTasks = new ArrayList<DashBoardItem>();
            NuxeoPrincipal pal = (NuxeoPrincipal)this.currentUser;
            List tasks = this.jbpmService.getCurrentTaskInstances(pal, null);
            if (tasks != null) {
                for (TaskInstance task : tasks) {
                    try {
                        if (task.hasEnded() || task.isCancelled()) continue;
                        DocumentModel doc = this.jbpmService.getDocumentModel(task, pal);
                        if (doc != null && !"deleted".equals(doc.getCurrentLifeCycleState())) {
                            this.currentUserTasks.add((DashBoardItem)new DashBoardItemImpl(task, doc));
                            continue;
                        }
                        log.warn((Object)String.format("User '%s' has a task of type '%s' on a missing or deleted document", this.currentUser.getName(), task.getName()));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        return this.currentUserTasks;
    }

    public Collection<DocumentProcessItem> computeDocumentProcessItems() throws ClientException {
        if (this.currentUserProcesses == null) {
            this.currentUserProcesses = new ArrayList<DocumentProcessItem>();
            NuxeoPrincipal pal = (NuxeoPrincipal)this.currentUser;
            List processes = this.jbpmService.getCurrentProcessInstances((NuxeoPrincipal)this.currentUser, null);
            if (processes != null) {
                for (ProcessInstance process : processes) {
                    try {
                        if (process.hasEnded()) continue;
                        DocumentModel doc = this.jbpmService.getDocumentModel(process, pal);
                        if (doc != null && !"deleted".equals(doc.getCurrentLifeCycleState())) {
                            this.currentUserProcesses.add((DocumentProcessItem)new DocumentProcessItemImpl(process, doc));
                            continue;
                        }
                        log.warn((Object)String.format("User '%s' has a process of type '%s' on a missing or deleted document", this.currentUser.getName(), process.getProcessDefinition().getName()));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        return this.currentUserProcesses;
    }

    @Observer(value={"workflowProcessEnded", "workflowNewProcessStarted", "workflowTaskStop", "workflowTaskRejected", "workflowUserAssignmentChanged", "workflowTaskCompleted", "workflowTaskRemoved", "workItemsListLoaded", "workflowTasksComputed", "workflowAbandoned", "workflowProcessCanceled", "domainSelectionChanged"}, create=false, inject=false)
    @BypassInterceptors
    public void invalidateDocumentProcessItems() {
        this.currentUserProcesses = null;
    }

    @Observer(value={"workflowProcessEnded", "workflowNewProcessStarted", "workflowTaskStart", "workflowTaskStop", "workflowTaskRejected", "workflowUserAssignmentChanged", "workflowTaskCompleted", "workflowTaskRemoved", "workItemsListLoaded", "workflowTasksComputed", "workflowAbandoned", "workflowProcessCanceled", "domainSelectionChanged", "documentPublicationRejected", "documentPublished"}, create=false, inject=false)
    @BypassInterceptors
    public void invalidateDashboardItems() {
        this.currentUserTasks = null;
    }

    public String refreshDashboardItems() {
        this.currentUserTasks = null;
        return null;
    }

    public String refreshDocumentProcessItems() {
        this.currentUserProcesses = null;
        return null;
    }
}

